/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.iot.client.trust;

import com.oracle.iot.client.impl.trust.TrustedAssetsManagerFactory;
import com.oracle.iot.client.trust.TrustException;
import java.io.Closeable;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.security.GeneralSecurityException;
import java.security.PublicKey;
import java.util.Vector;

public interface TrustedAssetsManager
extends Closeable {
    public static final String DISABLE_LONG_POLLING_PROPERTY = "com.oracle.iot.client.disable_long_polling";

    public String getServerHost();

    public int getServerPort();

    public String getServerScheme();

    public String getClientId();

    public PublicKey getPublicKey();

    public Vector<byte[]> getTrustAnchorCertificates();

    public void setEndPointCredentials(String var1, byte[] var2) throws TrustException;

    public String getEndpointId();

    public byte[] getEndpointCertificate();

    public void generateKeyPair(String var1, int var2) throws TrustException;

    public byte[] signWithPrivateKey(byte[] var1, String var2) throws TrustException;

    @Deprecated
    public byte[] getEncryptedSharedSecret() throws TrustException;

    public byte[] signWithSharedSecret(byte[] var1, String var2, String var3) throws TrustException;

    public boolean isActivated();

    public void reset() throws TrustException;

    public static class Factory {
        public static final String TAM_CLASS_PROPERTY = "oracle.iot.client.tam";

        public static TrustedAssetsManager getTrustedAssetsManager(Object context) throws GeneralSecurityException {
            String tamClass = System.getProperty(TAM_CLASS_PROPERTY);
            if (tamClass != null) {
                try {
                    Class<TrustedAssetsManager> clazz = TrustedAssetsManager.class;
                    Class<?> cl = Class.forName(tamClass);
                    Constructor<?> constructor = cl.getConstructor(Object.class);
                    Object tam = constructor.newInstance(context);
                    if (!clazz.isInstance(tam)) {
                        throw new ClassCastException("TrustedAssetsManager.getTrustedAssetsManager: can't convert " + tam);
                    }
                    return (TrustedAssetsManager)clazz.cast(tam);
                }
                catch (ClassNotFoundException e) {
                }
                catch (Exception e) {
                    InvocationTargetException i;
                    if (e instanceof InvocationTargetException && (i = (InvocationTargetException)e).getTargetException() instanceof GeneralSecurityException) {
                        throw (GeneralSecurityException)i.getTargetException();
                    }
                    throw new GeneralSecurityException("Cannot instantiate configure TrustedAssetsManager: " + tamClass, e);
                }
            }
            return TrustedAssetsManagerFactory.create(context);
        }

        public static TrustedAssetsManager getTrustedAssetsManager(String path, String password, Object context) throws GeneralSecurityException {
            if (path == null) {
                throw new GeneralSecurityException("Path is null");
            }
            String tamClass = System.getProperty(TAM_CLASS_PROPERTY, null);
            if (tamClass != null) {
                try {
                    Class<TrustedAssetsManager> clazz = TrustedAssetsManager.class;
                    Class<?> cl = Class.forName(tamClass);
                    Constructor<?> constructor = cl.getConstructor(String.class, String.class, Object.class);
                    Object tam = constructor.newInstance(path, password, context);
                    if (!clazz.isInstance(tam)) {
                        throw new ClassCastException("TrustedAssetsManager.getTrustedAssetsManager: can't convert " + tam);
                    }
                    return (TrustedAssetsManager)clazz.cast(tam);
                }
                catch (ClassNotFoundException e) {
                }
                catch (Exception e) {
                    InvocationTargetException i;
                    if (e instanceof InvocationTargetException && (i = (InvocationTargetException)e).getTargetException() instanceof GeneralSecurityException) {
                        throw (GeneralSecurityException)i.getTargetException();
                    }
                    throw new GeneralSecurityException("Cannot instantiate configure TrustedAssetsManager: " + tamClass, e);
                }
            }
            return TrustedAssetsManagerFactory.create(path, password, context);
        }

        private Factory() {
        }
    }
}

