/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.iot.client.message;

import com.oracle.iot.client.message.Message;

public final class DataItem<T> {
    private final String key;
    private final T value;
    private final Type type;

    public DataItem(String key, double value) {
        this(key, value, Type.DOUBLE);
        if (Double.isNaN(value) || Double.isInfinite(value)) {
            throw new IllegalArgumentException("Data Item: Double value is infinite or NaN");
        }
    }

    public DataItem(String key, boolean value) {
        this(key, value, Type.BOOLEAN);
    }

    public DataItem(String key, String value) {
        this(key, value, Type.STRING);
        Message.Utils.checkNullValueThrowsNPE(value, "Data Item: String value");
        Message.Utils.checkValueLengthAndThrowIAE(value, "Data Item: String value");
    }

    private DataItem(String key, Object value, Type type) {
        Message.Utils.checkNullValueThrowsNPE(key, "Data Item: Key");
        Message.Utils.checkEmptyStringThrowsIAE(key, "Data Item: Key");
        Message.Utils.checkKeyLengthAndThrowIAE(key, "Data Item: Key");
        this.key = key;
        this.type = type;
        this.value = value;
    }

    public final String getKey() {
        return this.key;
    }

    public final T getValue() {
        return this.value;
    }

    public final Type getType() {
        return this.type;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DataItem that = (DataItem)o;
        if (!this.key.equals(that.key)) {
            return false;
        }
        if (!this.type.equals((Object)that.getType())) {
            return false;
        }
        return this.value.equals(that.value);
    }

    public int hashCode() {
        int result = this.key.hashCode();
        result = 31 * result + this.value.hashCode();
        return result;
    }

    public static enum Type {
        STRING,
        DOUBLE,
        BOOLEAN;


        public String getValue() {
            return this.name();
        }

        public String toString() {
            return this.name();
        }
    }
}

