/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.iot.client.impl.enterprise;

import com.oracle.iot.client.impl.http.HttpSecureConnection;
import java.util.Map;
import java.util.WeakHashMap;
import oracle.iot.client.enterprise.EnterpriseClient;

public class SecureHttpConnectionMap {
    private static final Map<EnterpriseClient, HttpSecureConnection> secureConnectionMap = new WeakHashMap<EnterpriseClient, HttpSecureConnection>();

    public static HttpSecureConnection getSecureHttpConnection(EnterpriseClient client) {
        return secureConnectionMap.get(client);
    }

    public static void putSecureConnection(EnterpriseClient client, HttpSecureConnection secureConnection) {
        if (secureConnection == null) {
            secureConnectionMap.remove(client);
            return;
        }
        secureConnectionMap.put(client, secureConnection);
    }
}

