/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.iot.client.impl.enterprise;

import com.oracle.iot.client.HttpResponse;
import com.oracle.iot.client.RestApi;
import com.oracle.iot.client.enterprise.Resource;
import com.oracle.iot.client.enterprise.Response;
import com.oracle.iot.client.impl.enterprise.ResponseImpl;
import com.oracle.iot.client.impl.http.HttpSecureConnection;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ResourceImpl
implements Resource {
    private final HttpSecureConnection secureConnection;
    private final String appId;
    private final String deviceId;
    private final String id;
    private final String description;
    private final String url;
    private final List<String> methods;

    public ResourceImpl(HttpSecureConnection secureConnection, String appId, String deviceId, String id, String description, String url, List<String> methods) {
        this.secureConnection = secureConnection;
        this.appId = appId;
        this.deviceId = deviceId;
        this.id = id;
        this.description = description;
        this.url = url;
        this.methods = methods;
    }

    @Override
    public String getDeviceId() {
        return this.deviceId;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public String getURL() {
        return this.url;
    }

    @Override
    public List<String> getMethods() {
        return this.methods;
    }

    @Override
    public Response get(Map<String, String> queryparam, Map<String, String> headers) throws Exception {
        if (!this.methods.contains("GET")) {
            throw new UnsupportedOperationException("GET not supported");
        }
        String path = this.combineApiAndQuery(queryparam);
        HttpResponse res = this.secureConnection.get(path);
        return ResponseImpl.from(path, headers, res, this.secureConnection);
    }

    @Override
    public Response put(Map<String, String> queryparam, Map<String, String> headers, byte[] body) throws Exception {
        if (!this.methods.contains("PUT")) {
            throw new UnsupportedOperationException("PUT not supported");
        }
        String path = this.combineApiAndQuery(queryparam);
        HttpResponse res = this.secureConnection.put(path, body);
        return ResponseImpl.from(path, headers, res, this.secureConnection);
    }

    @Override
    public Response post(Map<String, String> queryparam, Map<String, String> headers, byte[] body) throws Exception {
        if (!this.methods.contains("POST")) {
            throw new UnsupportedOperationException("POST not supported");
        }
        String path = this.combineApiAndQuery(queryparam);
        HttpResponse res = this.secureConnection.post(path, body);
        return ResponseImpl.from(path, headers, res, this.secureConnection);
    }

    @Override
    public Response delete(Map<String, String> headers) throws Exception {
        if (!this.methods.contains("DELETE")) {
            throw new UnsupportedOperationException("DELETE not supported");
        }
        String path = this.combineApiAndQuery(null);
        HttpResponse res = this.secureConnection.delete(path);
        return ResponseImpl.from(path, headers, res, this.secureConnection);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("device ID = ");
        b.append(this.deviceId);
        b.append(", ID = ");
        b.append(this.id);
        b.append(", description = ");
        b.append(this.description);
        b.append(", URL = ");
        b.append(this.url);
        b.append(", methods = [");
        boolean first = true;
        for (String m : this.methods) {
            if (!first) {
                b.append(",");
            }
            b.append(m);
            first = false;
        }
        b.append("]");
        return b.toString();
    }

    private String combineApiAndQuery(Map<String, String> queryParams) {
        String query = "";
        if (queryParams != null) {
            Set<Map.Entry<String, String>> params = queryParams.entrySet();
            boolean first = true;
            for (Map.Entry<String, String> p : params) {
                if (first) {
                    query = "?";
                    first = false;
                } else {
                    query = query + "&";
                }
                query = query + p.getKey() + "=" + p.getValue();
            }
        }
        return RestApi.V2.getReqRoot() + "/apps/" + this.appId + "/devices/" + this.deviceId + "/resources/" + this.url + query;
    }
}

