/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.iot.client.message;

import com.oracle.iot.client.message.DataItem;
import com.oracle.iot.client.message.Message;
import com.oracle.iot.client.message.MessageParsingException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.json.JSONException;
import org.json.JSONObject;

public final class AlertMessage
extends Message {
    private String description;
    private Severity severity;
    private final String format;
    private final List<DataItem<?>> items;

    private AlertMessage(Builder builder) {
        super(builder);
        if (builder.format == null || builder.format.length() == 0) {
            throw new IllegalArgumentException("format cannot be null or empty.");
        }
        this.format = builder.format;
        this.description = builder.description;
        this.items = Collections.unmodifiableList(new ArrayList(builder.items));
        this.severity = builder.severity == null ? Severity.SIGNIFICANT : builder.severity;
    }

    public Severity getSeverity() {
        return this.severity;
    }

    public String getDescription() {
        return this.description;
    }

    public final String getFormat() {
        return this.format;
    }

    public final List<DataItem<?>> getDataItems() {
        return Collections.unmodifiableList(this.items);
    }

    @Override
    public Message.Type getType() {
        return Message.Type.ALERT;
    }

    @Override
    public final String toString() {
        return this.toJson().toString();
    }

    @Override
    public JSONObject toJson() {
        JSONObject jsonObject = Message.Utils.dataToJson(this, this.items, this.format, this.description, this.getSeverity().toString());
        try {
            jsonObject.put("type", (Object)Message.Type.ALERT.name());
        }
        catch (JSONException e) {
            throw new RuntimeException(e);
        }
        return jsonObject;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        AlertMessage that = (AlertMessage)o;
        if (this.description == null ? that.description != null : !this.description.equals(that.description)) {
            return false;
        }
        if (!this.severity.equals((Object)that.severity)) {
            return false;
        }
        return this.items.equals(that.items);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + this.items.hashCode();
        result = 31 * result + (this.description != null ? this.description.hashCode() : 0);
        result = 31 * result + this.severity.hashCode();
        return result;
    }

    public static final class Builder
    extends Message.MessageBuilder<Builder> {
        private String description;
        private Severity severity;
        private String format;
        private final List<DataItem<?>> items = new ArrayList();

        public Builder() {
            this.priority = Message.Priority.HIGHEST;
            this.severity = Severity.SIGNIFICANT;
        }

        @Override
        public Builder fromJson(JSONObject jsonObject) {
            try {
                JSONObject payload = jsonObject.getJSONObject("payload");
                Builder builder = (Builder)super.fromJson(jsonObject);
                builder.description = payload.optString("description", null);
                builder.severity = Severity.valueOf(payload.optString("severity", null));
                builder.format = payload.optString("format", null);
                Message.Utils.dataFromJson(jsonObject, builder.items);
                return builder;
            }
            catch (JSONException e) {
                throw new MessageParsingException(e);
            }
        }

        public final Builder severity(Severity severity) {
            this.severity = severity;
            return this.self();
        }

        public final Builder description(String description) {
            this.description = description;
            return this.self();
        }

        public final Builder format(String format) {
            this.format = format;
            return this.self();
        }

        public final <T> Builder dataItem(String key, double value) {
            this.items.add(new DataItem(key, value));
            return this.self();
        }

        public final <T> Builder dataItem(String key, boolean value) {
            this.items.add(new DataItem(key, value));
            return this.self();
        }

        public final <T> Builder dataItem(String key, String value) {
            this.items.add(new DataItem(key, value));
            return this.self();
        }

        public final <T> Builder dataItems(Collection<DataItem<?>> dataItems) {
            this.items.addAll(dataItems);
            return this.self();
        }

        @Override
        public final AlertMessage build() {
            return new AlertMessage(this);
        }

        @Override
        protected final Builder self() {
            return this;
        }
    }

    public static enum Severity {
        LOW(4),
        NORMAL(3),
        SIGNIFICANT(2),
        CRITICAL(1);

        private final int value;

        private Severity(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }
    }
}

