/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.iot.client.impl.device;

import com.oracle.iot.client.StorageObject;
import com.oracle.iot.client.device.DirectlyConnectedDevice;
import com.oracle.iot.client.device.util.StorageDispatcher;
import com.oracle.iot.client.impl.device.StorageObjectDelegate;
import java.io.IOException;
import java.util.LinkedList;
import java.util.Map;
import java.util.Queue;
import java.util.WeakHashMap;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

public class StorageDispatcherImpl
extends StorageDispatcher {
    private static final Map<DirectlyConnectedDevice, StorageDispatcherImpl> dispatcherMap = new WeakHashMap<DirectlyConnectedDevice, StorageDispatcherImpl>();
    private StorageDispatcher.ProgressCallback progressCallback;
    private final Thread contentThread;
    private final Lock contentLock = new ReentrantLock();
    private final Condition contentQueued = this.contentLock.newCondition();
    private boolean closed = false;
    private boolean requestClose = false;
    final Queue<StorageObjectDelegate> queue = new LinkedList<StorageObjectDelegate>();
    private static final Executor CALLBACK_DISPATCHER = Executors.newSingleThreadExecutor(new ThreadFactory(){

        @Override
        public Thread newThread(Runnable r) {
            SecurityManager s = System.getSecurityManager();
            ThreadGroup group = s != null ? s.getThreadGroup() : Thread.currentThread().getThreadGroup();
            Thread t = new Thread(group, r, "dispatcher-thread", 0L);
            if (!t.isDaemon()) {
                t.setDaemon(true);
            }
            if (t.getPriority() != 5) {
                t.setPriority(5);
            }
            return t;
        }
    });

    public static StorageDispatcher getStorageDispatcher(DirectlyConnectedDevice directlyConnectedDevice) {
        StorageDispatcherImpl storageDispatcher = dispatcherMap.get(directlyConnectedDevice);
        if (storageDispatcher == null || storageDispatcher.isClosed()) {
            storageDispatcher = new StorageDispatcherImpl();
            dispatcherMap.put(directlyConnectedDevice, storageDispatcher);
        }
        return storageDispatcher;
    }

    public StorageDispatcherImpl() {
        this.contentThread = new Thread((Runnable)new ContentTransmitter(), "ContentTransmitter-thread");
        this.contentThread.setDaemon(true);
        this.contentThread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void queue(StorageObject storageObject) {
        if (storageObject == null) {
            throw new IllegalArgumentException("StorageObject cannot be null.");
        }
        StorageObjectDelegate storageObjectDelegate = (StorageObjectDelegate)storageObject;
        StorageDispatcher.Progress.State state = storageObjectDelegate.getState();
        if (state != null) {
            switch (state) {
                case COMPLETED: {
                    return;
                }
                case QUEUED: 
                case IN_PROGRESS: {
                    throw new IllegalStateException("Transfer is pending.");
                }
            }
        }
        this.contentLock.lock();
        try {
            this.queue.offer(storageObjectDelegate);
            storageObjectDelegate.setState(StorageDispatcher.Progress.State.QUEUED);
            if (this.progressCallback != null) {
                ProgressImpl p = new ProgressImpl(storageObject);
                this.dispatchProgressCallback(p);
            }
            this.contentQueued.signal();
        }
        finally {
            this.contentLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cancel(StorageObject storageObject) {
        boolean cancelled = false;
        this.contentLock.lock();
        try {
            StorageDispatcher.Progress.State state = ((StorageObjectDelegate)storageObject).getState();
            if (state == StorageDispatcher.Progress.State.QUEUED) {
                cancelled = this.queue.remove((StorageObjectDelegate)storageObject);
            }
            if (cancelled || state == StorageDispatcher.Progress.State.IN_PROGRESS) {
                ((StorageObjectDelegate)storageObject).setState(StorageDispatcher.Progress.State.CANCELLED);
            }
        }
        finally {
            this.contentLock.unlock();
        }
        if (cancelled && this.progressCallback != null) {
            ProgressImpl p = new ProgressImpl(storageObject);
            this.dispatchProgressCallback(p);
        }
    }

    @Override
    public void setProgressCallback(StorageDispatcher.ProgressCallback callback) {
        this.progressCallback = callback;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        if (!this.closed) {
            this.requestClose = true;
            try {
                this.contentThread.interrupt();
                this.contentThread.join();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
            Map<DirectlyConnectedDevice, StorageDispatcherImpl> map = dispatcherMap;
            synchronized (map) {
                for (Map.Entry<DirectlyConnectedDevice, StorageDispatcherImpl> entry : dispatcherMap.entrySet()) {
                    if (!this.equals(entry.getValue())) continue;
                    dispatcherMap.remove(entry.getKey());
                    break;
                }
            }
            this.closed = true;
        }
    }

    public boolean isClosed() {
        return this.requestClose;
    }

    private boolean transferAndCallback(StorageObjectDelegate storageObjectDelegate) {
        StorageDispatcher.Progress.State state;
        ProgressImpl p = new ProgressImpl(storageObjectDelegate);
        try {
            storageObjectDelegate.sync();
            state = StorageDispatcher.Progress.State.COMPLETED;
            p.setBytesTransferred(storageObjectDelegate.getLength());
        }
        catch (Exception e) {
            if (storageObjectDelegate.isCancelled()) {
                state = StorageDispatcher.Progress.State.CANCELLED;
            }
            state = StorageDispatcher.Progress.State.FAILED;
            p.setFailureCause(e);
        }
        storageObjectDelegate.setState(state);
        p.setState(state);
        this.dispatchProgressCallback(p);
        return state == StorageDispatcher.Progress.State.COMPLETED;
    }

    void dispatchProgressCallback(final ProgressImpl p) {
        if (this.progressCallback != null) {
            CALLBACK_DISPATCHER.execute(new Runnable(){

                @Override
                public void run() {
                    StorageDispatcherImpl.this.progressCallback.progress(p);
                }
            });
        }
    }

    private class ContentTransmitter
    implements Runnable {
        private ContentTransmitter() {
        }

        @Override
        public void run() {
            while (!StorageDispatcherImpl.this.requestClose || !StorageDispatcherImpl.this.queue.isEmpty()) {
                StorageObjectDelegate storageObjectDelegate = null;
                StorageDispatcherImpl.this.contentLock.lock();
                try {
                    while (!StorageDispatcherImpl.this.requestClose && StorageDispatcherImpl.this.queue.isEmpty()) {
                        StorageDispatcherImpl.this.contentQueued.await();
                    }
                    storageObjectDelegate = StorageDispatcherImpl.this.queue.poll();
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
                finally {
                    StorageDispatcherImpl.this.contentLock.unlock();
                }
                if (storageObjectDelegate == null) continue;
                if (StorageDispatcherImpl.this.progressCallback != null) {
                    ProgressImpl p = new ProgressImpl(storageObjectDelegate);
                    StorageDispatcherImpl.this.dispatchProgressCallback(p);
                }
                StorageDispatcherImpl.this.transferAndCallback(storageObjectDelegate);
            }
        }
    }

    class ProgressImpl
    implements StorageDispatcher.Progress {
        private final StorageObject storageObject;
        private Exception exception = null;
        private long bytesTransferred = 0L;
        private StorageDispatcher.Progress.State state;

        ProgressImpl(StorageObject storageObject) {
            this.storageObject = storageObject;
            this.state = ((StorageObjectDelegate)storageObject).getState();
        }

        void setFailureCause(Exception e) {
            this.exception = e;
        }

        void setBytesTransferred(long bytesTransferred) {
            this.bytesTransferred = bytesTransferred;
        }

        void setState(StorageDispatcher.Progress.State state) {
            this.state = state;
        }

        @Override
        public StorageObject getStorageObject() {
            return this.storageObject;
        }

        @Override
        public StorageDispatcher.Progress.State getState() {
            return this.state;
        }

        @Override
        public Exception getFailureCause() {
            return this.exception;
        }

        @Override
        public long getBytesTransferred() {
            return this.bytesTransferred;
        }
    }
}

