/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.iot.client.impl.device;

import com.oracle.iot.client.impl.device.Utils;
import com.oracle.iot.client.impl.device.http.HttpSendReceiveImpl;
import com.oracle.iot.client.message.Message;
import com.oracle.iot.client.message.RequestMessage;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.security.GeneralSecurityException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public abstract class SendReceiveImpl {
    private static final short DEFAULT_REQUEST_BUFFER_SIZE = 4192;
    private static final short DEFAULT_SEND_RECEIVE_TIMEOUT = 100;
    protected static final String REQUEST_BUFFER_SIZE_PROPERTY = "oracle.iot.client.device.request_buffer_size";
    private static final String DISABLE_LONG_POLLING_PROPERTY = "com.oracle.iot.client.disable_long_polling";
    private static final String SEND_RECEIVE_TIMEOUT_PROPERTY = "oracle.iot.client.device.send_receive_timeout";
    private static final String MIN_ACCEPT_BYTES_HEADER = "X-min-acceptBytes";
    private static final int USE_DEFAULT_TIMEOUT_VALUE = -1;
    private final byte[] requestBuffer;
    private int head = 0;
    private int tail = 0;
    protected final boolean useLongPolling;
    private final short sendReceiveTimeLimit;
    private long sendCallTime = -1L;
    private final short requestBufferSize = SendReceiveImpl.getShortPropertyValue("oracle.iot.client.device.request_buffer_size", (short)4192);
    private static final Logger LOGGER = Logger.getLogger("oracle.iot.client");

    private static short getShortPropertyValue(String key, short defaultValue) {
        short imax = Utils.getShortProperty(key, defaultValue);
        short max = imax > defaultValue ? imax : defaultValue;
        return max > 0 ? max : defaultValue;
    }

    private static short getSendReceiveTimeout(String key, short defaultValue) {
        short imax = Utils.getShortProperty(key, defaultValue);
        if (imax == 0) {
            return 0;
        }
        short max = imax > defaultValue ? imax : defaultValue;
        return max > 0 ? max : defaultValue;
    }

    protected SendReceiveImpl() {
        this.sendReceiveTimeLimit = SendReceiveImpl.getSendReceiveTimeout(SEND_RECEIVE_TIMEOUT_PROPERTY, (short)100);
        this.requestBuffer = new byte[this.requestBufferSize];
        this.useLongPolling = this instanceof HttpSendReceiveImpl && !Boolean.getBoolean(DISABLE_LONG_POLLING_PROPERTY);
    }

    public final void send(Message ... messages) throws IOException, GeneralSecurityException {
        byte[] payload = null;
        if (messages != null && messages.length > 0) {
            JSONArray jsonArray = new JSONArray();
            for (Message message : messages) {
                jsonArray.put((Object)message.toJson());
            }
            payload = jsonArray.toString().getBytes(Charset.forName("UTF-8"));
        }
        this.post(payload);
        if (!this.useLongPolling) {
            this.sendCallTime = System.currentTimeMillis();
        }
    }

    public final synchronized RequestMessage receive(long timeout) throws IOException, GeneralSecurityException {
        if (this.head == this.tail) {
            if (!this.useLongPolling) {
                long receiveCallTime = System.currentTimeMillis();
                if (this.sendReceiveTimeLimit == 0 || receiveCallTime - this.sendCallTime < (long)this.sendReceiveTimeLimit) {
                    return null;
                }
                this.post(null, -1);
                this.sendCallTime = System.currentTimeMillis();
            } else {
                this.post(null, (int)timeout);
            }
        }
        if (this.head != this.tail) {
            InputStreamReader reader;
            int nBytes = 0;
            nBytes += (this.requestBuffer[this.head++ % this.requestBuffer.length] & 0xFF) << 8;
            int offset = this.head;
            this.head = (this.head + (nBytes += this.requestBuffer[this.head++ % this.requestBuffer.length] & 0xFF)) % this.requestBuffer.length;
            JSONObject jsonObject = null;
            try {
                reader = new InputStreamReader((InputStream)new CircularBufferInputStream(this.requestBuffer, offset, nBytes), "UTF-8");
            }
            catch (UnsupportedEncodingException ignored) {
                return null;
            }
            try {
                int c;
                StringBuilder stringBuilder = new StringBuilder(nBytes);
                while ((c = reader.read()) != -1) {
                    stringBuilder.append((char)c);
                }
                String json = stringBuilder.toString();
                jsonObject = new JSONObject(json);
            }
            catch (JSONException e) {
                throw new IOException(e);
            }
            finally {
                try {
                    reader.close();
                }
                catch (IOException ingored) {}
            }
            if (SendReceiveImpl.getLogger().isLoggable(Level.FINE)) {
                SendReceiveImpl.getLogger().log(Level.FINE, "dequeued: " + Message.prettyPrintJson(jsonObject));
            }
            RequestMessage.Builder builder = new RequestMessage.Builder().fromJson(jsonObject);
            return builder.build();
        }
        return null;
    }

    protected abstract void post(byte[] var1) throws IOException, GeneralSecurityException;

    protected abstract void post(byte[] var1, int var2) throws IOException, GeneralSecurityException;

    protected final synchronized int getUsedBytes() {
        return this.tail >= this.head ? this.tail - this.head : this.tail + this.requestBuffer.length - this.head;
    }

    protected final int getRequestBufferSize() {
        return this.requestBuffer.length;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected final synchronized void bufferRequest(byte[] data) {
        if (data != null && data.length > 2) {
            int pos = 1;
            while (data[pos] == 123) {
                InputStreamReader reader;
                int start = pos;
                int lengthIndex0 = this.tail;
                this.tail += 2;
                int braceCount = 0;
                while (pos < data.length) {
                    byte b = data[pos++];
                    this.requestBuffer[this.tail++ % this.requestBuffer.length] = b;
                    if (b == 123) {
                        ++braceCount;
                        continue;
                    }
                    if (b != 125 || --braceCount != 0) continue;
                }
                int nbytes = pos - start;
                this.requestBuffer[lengthIndex0++ % this.requestBuffer.length] = (byte)((0xFF00 & nbytes) >> 8);
                this.requestBuffer[lengthIndex0 % this.requestBuffer.length] = (byte)(0xFF & nbytes);
                if (pos < data.length && data[pos] == 125) {
                    ++pos;
                }
                if (pos < data.length && data[pos] == 44) {
                    ++pos;
                }
                if (!SendReceiveImpl.getLogger().isLoggable(Level.FINE)) continue;
                try {
                    reader = new InputStreamReader((InputStream)new CircularBufferInputStream(this.requestBuffer, start, nbytes), "UTF-8");
                }
                catch (UnsupportedEncodingException ignored) {
                    return;
                }
                try {
                    int c;
                    StringBuilder stringBuilder = new StringBuilder(nbytes);
                    while ((c = reader.read()) != -1) {
                        stringBuilder.append((char)c);
                    }
                    String json = stringBuilder.toString();
                    JSONObject jsonObject = new JSONObject(json);
                    SendReceiveImpl.getLogger().log(Level.FINE, "buffered: " + Message.prettyPrintJson(jsonObject));
                }
                catch (JSONException ignored) {
                }
                catch (IOException ignored) {
                }
                finally {
                    try {
                        reader.close();
                    }
                    catch (IOException ignored) {}
                }
            }
        }
        this.tail %= this.requestBuffer.length;
        if (data != null && data.length > 2 && SendReceiveImpl.getLogger().isLoggable(Level.FINE)) {
            int availableBytes = this.getRequestBufferSize() - this.getUsedBytes() - 2;
            SendReceiveImpl.getLogger().log(Level.FINE, "buffered " + data.length + " bytes of request data from server. " + availableBytes + " available bytes of " + this.getRequestBufferSize() + " remaining in buffer.");
        }
    }

    private static Logger getLogger() {
        return LOGGER;
    }

    private static class CircularBufferInputStream
    extends InputStream {
        private final byte[] buffer;
        private int pos;
        private final int eos;

        private CircularBufferInputStream(byte[] buffer, int head, int nBytes) {
            this.buffer = buffer;
            this.pos = head;
            this.eos = this.pos + nBytes;
            if (nBytes > buffer.length) {
                throw new IllegalArgumentException(nBytes + " bytes requested but buffer only has " + buffer.length + " bytes");
            }
        }

        @Override
        public synchronized int read() throws IOException {
            return this.pos < this.eos ? this.buffer[this.pos++ % this.buffer.length] : -1;
        }

        @Override
        public void close() throws IOException {
        }
    }
}

