/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.iot.client.device;

import com.oracle.iot.client.device.DirectlyConnectedDevice;
import com.oracle.iot.client.impl.device.ActivationManager;
import com.oracle.iot.client.impl.device.IndirectActivationRequest;
import com.oracle.iot.client.impl.device.IndirectActivationResponse;
import com.oracle.iot.client.trust.TrustException;
import com.oracle.iot.client.trust.TrustedAssetsManager;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.util.Map;
import java.util.logging.Logger;

public class GatewayDevice
extends DirectlyConnectedDevice {
    public static final String MANUFACTURER = "manufacturer";
    public static final String MODEL_NUMBER = "modelNumber";
    public static final String SERIAL_NUMBER = "serialNumber";
    public static final String DEVICE_CLASS = "deviceClass";
    public static final String PROTOCOL = "protocol";
    public static final String PROTOCOL_DEVICE_CLASS = "protocolDeviceClass";
    public static final String PROTOCOL_DEVICE_ID = "protocolDeviceId";
    private static final Logger LOGGER = Logger.getLogger("oracle.iot.client");

    public GatewayDevice() throws GeneralSecurityException {
    }

    public GatewayDevice(Object context) throws GeneralSecurityException {
        super(context);
    }

    public GatewayDevice(String configFilePath, String configFilePassword) throws GeneralSecurityException {
        super(configFilePath, configFilePassword);
    }

    public GatewayDevice(String configFilePath, String configFilePassword, Object context) throws GeneralSecurityException {
        super(configFilePath, configFilePassword, context);
    }

    GatewayDevice(TrustedAssetsManager trustedAssetManager) throws GeneralSecurityException {
        super(trustedAssetManager);
    }

    public String registerDevice(String hardwareId, Map<String, String> metaData, String ... deviceModels) throws IOException, GeneralSecurityException {
        return this.registerDevice(false, hardwareId, metaData, deviceModels);
    }

    public String registerDevice(boolean restricted, String hardwareId, Map<String, String> metaData, String ... deviceModels) throws IOException, GeneralSecurityException {
        if (hardwareId == null) {
            throw new IllegalArgumentException("hardwareId cannot be null");
        }
        if (deviceModels == null || deviceModels.length == 0) {
            throw new IllegalArgumentException("at least one device model must be given");
        }
        byte[] data = this.getEndpointId().getBytes("UTF-8");
        byte[] signature = null;
        try {
            signature = this.trustedAssetsManager.signWithSharedSecret(data, "HmacSHA256", hardwareId);
        }
        catch (TrustException e) {
            if (e.getCause() != null) {
                throw e;
            }
            signature = null;
        }
        if (restricted && signature == null) {
            signature = this.trustedAssetsManager.signWithPrivateKey(data, "SHA256withRSA");
        }
        IndirectActivationRequest indirectActivationRequest = ActivationManager.createIndirectActivationRequest(hardwareId, metaData, deviceModels, signature);
        IndirectActivationResponse indirectActivationResponse = ActivationManager.postIndirectActivationRequest(this.secureConnection, indirectActivationRequest);
        return indirectActivationResponse.getEndpointId();
    }

    private static Logger getLogger() {
        return LOGGER;
    }
}

