/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.iot.client.device;

import com.oracle.iot.client.SecureConnection;
import com.oracle.iot.client.StorageObject;
import com.oracle.iot.client.device.GatewayDevice;
import com.oracle.iot.client.impl.DeviceModelFactory;
import com.oracle.iot.client.impl.StorageConnectionBase;
import com.oracle.iot.client.impl.device.ActivationManager;
import com.oracle.iot.client.impl.device.ActivationPolicyResponse;
import com.oracle.iot.client.impl.device.DirectActivationRequest;
import com.oracle.iot.client.impl.device.DirectActivationResponse;
import com.oracle.iot.client.impl.device.SendReceiveImpl;
import com.oracle.iot.client.impl.device.StorageConnectionImpl;
import com.oracle.iot.client.impl.device.http.HttpSendReceiveImpl;
import com.oracle.iot.client.impl.device.mqtt.MqttSecureConnection;
import com.oracle.iot.client.impl.device.mqtt.MqttSendReceiveImpl;
import com.oracle.iot.client.impl.http.HttpSecureConnection;
import com.oracle.iot.client.message.Message;
import com.oracle.iot.client.message.RequestMessage;
import com.oracle.iot.client.trust.TrustedAssetsManager;
import java.io.Closeable;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.security.GeneralSecurityException;
import java.util.HashSet;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.iot.client.DeviceModel;

public class DirectlyConnectedDevice
implements Closeable {
    private static final int USE_DEFAULT_TIMEOUT_VALUE = -1;
    private SendReceiveImpl sendReceiveImpl;
    final SecureConnection secureConnection;
    private final boolean isMqtt;
    protected final TrustedAssetsManager trustedAssetsManager;
    private static final Logger LOGGER = Logger.getLogger("oracle.iot.client");

    public DirectlyConnectedDevice() throws GeneralSecurityException {
        this(TrustedAssetsManager.Factory.getTrustedAssetsManager(null));
    }

    public DirectlyConnectedDevice(Object context) throws GeneralSecurityException {
        this(TrustedAssetsManager.Factory.getTrustedAssetsManager(context));
    }

    public DirectlyConnectedDevice(String configFilePath, String configFilePassword) throws GeneralSecurityException {
        this(configFilePath, configFilePassword, null);
    }

    public DirectlyConnectedDevice(String configFilePath, String configFilePassword, Object context) throws GeneralSecurityException {
        this(TrustedAssetsManager.Factory.getTrustedAssetsManager(configFilePath, configFilePassword, context));
    }

    DirectlyConnectedDevice(TrustedAssetsManager trustedAssetsManager) throws GeneralSecurityException {
        this.trustedAssetsManager = trustedAssetsManager;
        String scheme = trustedAssetsManager.getServerScheme();
        this.isMqtt = "mqtts".equals(scheme);
        if (!this.isMqtt && !"https".equals(scheme)) {
            throw new GeneralSecurityException("Unsupported server scheme: " + scheme);
        }
        this.secureConnection = this.createSecureConnection();
        if (trustedAssetsManager.isActivated()) {
            this.sendReceiveImpl = this.createSendReceiveImpl();
        }
    }

    public StorageObject createStorageObject(String name, String contentType) throws IOException, GeneralSecurityException {
        StorageConnectionBase storageConnection = StorageConnectionMap.getStorageConnection(this.secureConnection);
        return storageConnection.createStorageObject(this.getEndpointId(), name, contentType);
    }

    public StorageObject createStorageObject(String uri) throws IOException, GeneralSecurityException {
        StorageConnectionBase storageConnection = StorageConnectionMap.getStorageConnection(this.secureConnection);
        return storageConnection.createStorageObject(uri);
    }

    public final void activate(String ... deviceModels) throws IOException, GeneralSecurityException {
        if (this.isActivated()) {
            throw new IllegalStateException("already activated");
        }
        ActivationPolicyResponse activationPolicyResponse = ActivationManager.getActivationPolicy(this.secureConnection, this.trustedAssetsManager.getClientId());
        if (DirectlyConnectedDevice.getLogger().isLoggable(Level.FINER)) {
            DirectlyConnectedDevice.getLogger().log(Level.FINER, "activationPolicyResponse: " + String.valueOf(activationPolicyResponse));
        }
        this.trustedAssetsManager.generateKeyPair(activationPolicyResponse.getKeyType(), activationPolicyResponse.getKeySize());
        HashSet<String> deviceModelSet = new HashSet<String>();
        if (deviceModels != null) {
            for (String deviceModel : deviceModels) {
                deviceModelSet.add(deviceModel);
            }
        }
        deviceModelSet.add("urn:oracle:iot:dcd:capability:direct_activation");
        if (this instanceof GatewayDevice) {
            deviceModelSet.add("urn:oracle:iot:dcd:capability:indirect_activation");
        }
        DirectActivationRequest directActivationRequest = ActivationManager.createDirectActivationRequest(this.trustedAssetsManager, activationPolicyResponse.getHashAlgorithm(), deviceModelSet);
        if (DirectlyConnectedDevice.getLogger().isLoggable(Level.FINER)) {
            DirectlyConnectedDevice.getLogger().log(Level.FINER, "directActivationRequest: " + directActivationRequest.toString());
        }
        DirectActivationResponse directActivationResponse = ActivationManager.postDirectActivationRequest(this.secureConnection, directActivationRequest);
        if (DirectlyConnectedDevice.getLogger().isLoggable(Level.FINER)) {
            DirectlyConnectedDevice.getLogger().log(Level.FINER, "directActivationResponse: Endpoint state is: " + directActivationResponse.getEndpointState());
        }
        String endpointId = directActivationResponse.getEndpointId();
        byte[] certificate = directActivationResponse.getCertificate();
        this.trustedAssetsManager.setEndPointCredentials(endpointId, certificate);
        this.secureConnection.disconnect();
        this.sendReceiveImpl = this.createSendReceiveImpl();
    }

    public final boolean isActivated() {
        return this.trustedAssetsManager.isActivated();
    }

    public final void send(Message ... messages) throws IOException, GeneralSecurityException {
        if (!this.isActivated()) {
            throw new IllegalStateException("not activated");
        }
        this.sendReceiveImpl.send(messages);
    }

    public final RequestMessage receive(long timeout) throws IOException, GeneralSecurityException {
        if (this.isActivated()) {
            long connectionTimeout = timeout == 0L ? -1L : (timeout < 0L ? 0L : timeout);
            return this.sendReceiveImpl.receive(connectionTimeout);
        }
        throw new IllegalStateException("not activated");
    }

    public final String getEndpointId() {
        return this.trustedAssetsManager.getEndpointId();
    }

    public final DeviceModel getDeviceModel(String deviceModel) throws IOException, GeneralSecurityException {
        return DeviceModelFactory.getDeviceModel(this.secureConnection, deviceModel);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        DirectlyConnectedDevice other = (DirectlyConnectedDevice)obj;
        if (this.isActivated() ^ other.isActivated()) {
            return false;
        }
        if (!this.trustedAssetsManager.getServerHost().equals(other.trustedAssetsManager.getServerHost())) {
            return false;
        }
        if (this.trustedAssetsManager.getServerPort() != other.trustedAssetsManager.getServerPort()) {
            return false;
        }
        if (!this.isActivated()) {
            return this.trustedAssetsManager.getClientId().equals(other.trustedAssetsManager.getClientId());
        }
        if (!this.trustedAssetsManager.getEndpointId().equals(other.trustedAssetsManager.getEndpointId())) {
            return false;
        }
        if (this.trustedAssetsManager.getPublicKey() == null) {
            return other.trustedAssetsManager.getPublicKey() == null;
        }
        return this.trustedAssetsManager.getPublicKey().equals(other.trustedAssetsManager.getPublicKey());
    }

    public int hashCode() {
        int hash = 37;
        hash = 37 * hash + (this.isActivated() ? this.trustedAssetsManager.getEndpointId().hashCode() : this.trustedAssetsManager.getClientId().hashCode()) + this.trustedAssetsManager.getServerHost().hashCode() + this.trustedAssetsManager.getServerPort();
        return hash;
    }

    @Override
    public void close() throws IOException {
        this.secureConnection.close();
    }

    private SendReceiveImpl createSendReceiveImpl() {
        if (this.isMqtt) {
            MqttSendReceiveImpl impl = new MqttSendReceiveImpl((MqttSecureConnection)this.secureConnection);
            impl.initialize();
            return impl;
        }
        return new HttpSendReceiveImpl((HttpSecureConnection)this.secureConnection);
    }

    private SecureConnection createSecureConnection() throws GeneralSecurityException {
        try {
            return this.isMqtt ? MqttSecureConnection.createSecureMqttConnection(this.trustedAssetsManager, this instanceof GatewayDevice) : HttpSecureConnection.createHttpSecureConnection(this.trustedAssetsManager, false);
        }
        catch (NoClassDefFoundError e) {
            if (this.isMqtt) {
                throw new GeneralSecurityException("Unable to initialize Mqtt Secure Connection, NoClassDefFoundError: " + e.getMessage() + ".");
            }
            throw new GeneralSecurityException("Unable to initialize Http Secure Connection, NoClassDefFoundError: " + e.getMessage());
        }
    }

    private static Logger getLogger() {
        return LOGGER;
    }

    private static class StorageConnectionMap {
        private static final Map<SecureConnection, WeakReference<StorageConnectionBase>> STORAGE_CONNECTION_MAP = new WeakHashMap<SecureConnection, WeakReference<StorageConnectionBase>>();

        private StorageConnectionMap() {
        }

        private static StorageConnectionBase getStorageConnection(SecureConnection secureConnection) {
            WeakReference<StorageConnectionBase> reference = STORAGE_CONNECTION_MAP.get(secureConnection);
            StorageConnectionBase storageConnection = null;
            if (reference != null) {
                storageConnection = (StorageConnectionBase)reference.get();
            }
            if (storageConnection == null) {
                storageConnection = new StorageConnectionImpl(secureConnection);
                STORAGE_CONNECTION_MAP.put(secureConnection, new WeakReference<StorageConnectionBase>(storageConnection));
            }
            return storageConnection;
        }
    }
}

