/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.iot.client;

import com.oracle.iot.client.ExternalObject;

public abstract class DeviceModelAttribute<T> {
    public abstract String getName();

    public abstract String getModel();

    public abstract String getDescription();

    public abstract Type getType();

    public abstract Number getLowerBound();

    public abstract Number getUpperBound();

    public abstract Access getAccess();

    @Deprecated
    public abstract String getAlias();

    public T getDefaultValue() {
        return null;
    }

    protected DeviceModelAttribute() {
    }

    public static enum Access {
        READ_ONLY,
        WRITE_ONLY,
        READ_WRITE,
        EXECUTABLE;

    }

    public static enum Type {
        NUMBER{

            @Override
            public Float fromString(String str) {
                return Float.valueOf(str);
            }
        }
        ,
        STRING{

            @Override
            public String fromString(String str) {
                return str;
            }
        }
        ,
        URI{

            @Override
            public ExternalObject fromString(String str) {
                return new ExternalObject(str);
            }
        }
        ,
        BOOLEAN{

            @Override
            public Boolean fromString(String str) {
                return Boolean.valueOf(str);
            }
        }
        ,
        INTEGER{

            @Override
            public Integer fromString(String str) {
                return Integer.valueOf(str);
            }
        }
        ,
        DATETIME{

            @Override
            public Long fromString(String str) {
                return Long.parseLong(str);
            }
        };


        public abstract Object fromString(String var1);
    }
}

