/*
 * Decompiled with CFR 0.152.
 */
package oracle.iot.client.enterprise;

import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public abstract class Filter {
    public static Filter and(Filter ... filters) {
        return new CompositeFilter("$and", filters);
    }

    public static Filter or(Filter ... filters) {
        return new CompositeFilter("$or", filters);
    }

    public static Filter not(Filter filter) {
        return new CompositeFilter("$not", new Filter[]{filter});
    }

    public static Filter eq(String op1, String op2) {
        return new SimpleFilter("$eq", op1, op2);
    }

    public static Filter eq(String op1, long op2) {
        return new SimpleFilter("$eq", op1, op2);
    }

    public static Filter eq(String op1, double op2) {
        return new SimpleFilter("$eq", op1, op2);
    }

    public static Filter eq(String op1, boolean op2) {
        return new SimpleFilter("$eq", op1, op2);
    }

    public static Filter gt(String op1, long op2) {
        return new SimpleFilter("$gt", op1, op2);
    }

    public static Filter gt(String op1, double op2) {
        return new SimpleFilter("$gt", op1, op2);
    }

    public static Filter gte(String op1, long op2) {
        return new SimpleFilter("$gte", op1, op2);
    }

    public static Filter gte(String op1, double op2) {
        return new SimpleFilter("$gte", op1, op2);
    }

    public static Filter lt(String op1, long op2) {
        return new SimpleFilter("$lt", op1, op2);
    }

    public static Filter lt(String op1, double op2) {
        return new SimpleFilter("$lt", op1, op2);
    }

    public static Filter lte(String op1, long op2) {
        return new SimpleFilter("$lte", op1, op2);
    }

    public static Filter lte(String op1, double op2) {
        return new SimpleFilter("$lte", op1, op2);
    }

    public static Filter ne(String op1, String op2) {
        return new SimpleFilter("$ne", op1, op2);
    }

    public static Filter ne(String op1, long op2) {
        return new SimpleFilter("$ne", op1, op2);
    }

    public static Filter ne(String op1, double op2) {
        return new SimpleFilter("$ne", op1, op2);
    }

    public static Filter ne(String op1, boolean op2) {
        return new SimpleFilter("$ne", op1, op2);
    }

    public static Filter in(String key, String[] values) {
        return new SimpleFilter("$in", key, values);
    }

    public static Filter in(String key, long[] values) {
        return new SimpleFilter("$in", key, values);
    }

    public static Filter in(String key, double[] values) {
        return new SimpleFilter("$in", key, values);
    }

    public static Filter in(String key, boolean[] values) {
        return new SimpleFilter("$in", key, values);
    }

    public static Filter exists(String op1, boolean e) {
        return new SimpleFilter("$exists", op1, e);
    }

    public static Filter like(String value, String pattern) {
        return new SimpleFilter("$like", value, pattern);
    }

    public abstract JSONObject toJson();

    private static class SimpleFilter
    extends Filter {
        private final JSONObject value;

        SimpleFilter(String operator, String name, String value) {
            try {
                this.value = new JSONObject().put(name, (Object)new JSONObject().put(operator, (Object)value));
            }
            catch (JSONException e) {
                throw new RuntimeException(e);
            }
        }

        SimpleFilter(String operator, String name, long value) {
            try {
                this.value = new JSONObject().put(name, (Object)new JSONObject().put(operator, value));
            }
            catch (JSONException e) {
                throw new RuntimeException(e);
            }
        }

        SimpleFilter(String operator, String name, double value) {
            try {
                this.value = new JSONObject().put(name, (Object)new JSONObject().put(operator, value));
            }
            catch (JSONException e) {
                throw new RuntimeException(e);
            }
        }

        SimpleFilter(String operator, String name, boolean value) {
            try {
                this.value = new JSONObject().put(name, (Object)new JSONObject().put(operator, value));
            }
            catch (JSONException e) {
                throw new RuntimeException(e);
            }
        }

        SimpleFilter(String operator, String name, String[] value) {
            try {
                JSONArray array = new JSONArray();
                for (String f : value) {
                    array.put((Object)f);
                }
                this.value = new JSONObject().put(name, (Object)new JSONObject().put(operator, (Object)array));
            }
            catch (JSONException e) {
                throw new RuntimeException(e);
            }
        }

        SimpleFilter(String operator, String name, long[] value) {
            try {
                JSONArray array = new JSONArray();
                for (long f : value) {
                    array.put(f);
                }
                this.value = new JSONObject().put(name, (Object)new JSONObject().put(operator, (Object)array));
            }
            catch (JSONException e) {
                throw new RuntimeException(e);
            }
        }

        SimpleFilter(String operator, String name, double[] value) {
            try {
                JSONArray array = new JSONArray();
                for (double f : value) {
                    array.put(f);
                }
                this.value = new JSONObject().put(name, (Object)new JSONObject().put(operator, (Object)array));
            }
            catch (JSONException e) {
                throw new RuntimeException(e);
            }
        }

        SimpleFilter(String operator, String name, boolean[] value) {
            try {
                JSONArray array = new JSONArray();
                for (boolean f : value) {
                    array.put(f);
                }
                this.value = new JSONObject().put(name, (Object)new JSONObject().put(operator, (Object)array));
            }
            catch (JSONException e) {
                throw new RuntimeException(e);
            }
        }

        public String toString() {
            return this.toJson().toString();
        }

        @Override
        public JSONObject toJson() {
            return this.value;
        }
    }

    private static class CompositeFilter
    extends Filter {
        private final Filter[] operands;
        private final String operator;

        CompositeFilter(String operator, Filter[] operands) {
            this.operator = operator;
            this.operands = operands;
        }

        public String toString() {
            return this.toJson().toString();
        }

        @Override
        public JSONObject toJson() {
            try {
                if (this.operands.length > 1) {
                    JSONArray array = new JSONArray();
                    for (Filter f : this.operands) {
                        array.put((Object)f.toJson());
                    }
                    return new JSONObject().put(this.operator, (Object)array);
                }
                return new JSONObject().put(this.operator, (Object)this.operands[0].toJson());
            }
            catch (JSONException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

