/*
 * Decompiled with CFR 0.152.
 */
package oracle.iot.client.device;

import com.oracle.iot.client.device.util.MessageDispatcher;
import com.oracle.iot.client.impl.DeviceModelImpl;
import com.oracle.iot.client.impl.device.StorageObjectImpl;
import com.oracle.iot.client.impl.device.VirtualDeviceImpl;
import java.io.IOException;
import java.security.GeneralSecurityException;
import oracle.iot.client.Client;
import oracle.iot.client.DeviceModel;
import oracle.iot.client.StorageObject;
import oracle.iot.client.device.VirtualDevice;

public class DirectlyConnectedDevice
extends Client<VirtualDevice> {
    final com.oracle.iot.client.device.DirectlyConnectedDevice dcdImpl;

    public DirectlyConnectedDevice() throws GeneralSecurityException {
        this(null);
    }

    public DirectlyConnectedDevice(Object context) throws GeneralSecurityException {
        super(context);
        this.dcdImpl = new com.oracle.iot.client.device.DirectlyConnectedDevice(context);
        if (this.isActivated()) {
            MessageDispatcher.getMessageDispatcher(this.dcdImpl);
        }
    }

    public DirectlyConnectedDevice(String configFilePath, String configFilePassword) throws GeneralSecurityException {
        this(configFilePath, configFilePassword, null);
    }

    public DirectlyConnectedDevice(String configFilePath, String configFilePassword, Object context) throws GeneralSecurityException {
        super(context);
        this.dcdImpl = new com.oracle.iot.client.device.DirectlyConnectedDevice(configFilePath, configFilePassword, context);
        if (this.isActivated()) {
            MessageDispatcher.getMessageDispatcher(this.dcdImpl);
        }
    }

    DirectlyConnectedDevice(com.oracle.iot.client.device.DirectlyConnectedDevice dcdImpl, Object context) {
        super(context);
        this.dcdImpl = dcdImpl;
        if (this.isActivated()) {
            MessageDispatcher.getMessageDispatcher(dcdImpl);
        }
    }

    public final void activate(String ... deviceModels) throws IOException, GeneralSecurityException {
        String[] dmArray = new String[deviceModels != null ? deviceModels.length + 2 : 2];
        dmArray[0] = "urn:oracle:iot:dcd:capability:diagnostics";
        dmArray[1] = "urn:oracle:iot:dcd:capability:message_dispatcher";
        if (deviceModels != null) {
            System.arraycopy(deviceModels, 0, dmArray, 2, deviceModels.length);
        }
        this.dcdImpl.activate(dmArray);
        MessageDispatcher.getMessageDispatcher(this.dcdImpl);
    }

    public final boolean isActivated() {
        return this.dcdImpl.isActivated();
    }

    public final String getEndpointId() {
        return this.dcdImpl.getEndpointId();
    }

    @Override
    public final VirtualDevice createVirtualDevice(String endpointId, DeviceModel deviceModel) {
        if (endpointId == null) {
            throw new NullPointerException("endpointId may not be null");
        }
        if (deviceModel == null) {
            throw new NullPointerException("deviceModel may not be null");
        }
        if (!(deviceModel instanceof DeviceModelImpl)) {
            throw new IllegalArgumentException("device model must be an instanceof com.oracle.iot.client.impl.DeviceModelImpl");
        }
        return new VirtualDeviceImpl(this.dcdImpl, endpointId, (DeviceModelImpl)deviceModel);
    }

    @Override
    public final DeviceModel getDeviceModel(String deviceModelUrn) throws IOException, GeneralSecurityException {
        return this.dcdImpl.getDeviceModel(deviceModelUrn);
    }

    @Override
    public void close() throws IOException {
        try {
            if (this.isActivated()) {
                MessageDispatcher.getMessageDispatcher(this.dcdImpl).close();
            }
        }
        finally {
            this.dcdImpl.close();
        }
    }

    @Override
    public StorageObject createStorageObject(String name, String contentType) throws IOException, GeneralSecurityException {
        com.oracle.iot.client.StorageObject delegate = this.dcdImpl.createStorageObject(name, contentType);
        return new StorageObjectImpl(this.dcdImpl, delegate);
    }
}

