/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.iot.client.message;

import com.oracle.iot.client.message.Message;
import com.oracle.iot.client.message.MessageParsingException;
import com.oracle.iot.client.message.Resource;
import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.text.Collator;
import java.util.ArrayList;
import java.util.List;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public final class ResourceMessage
extends Message {
    private ArrayList<Resource> resources;
    private Type type;
    private String reconciliationMark;
    private String endpointName;
    private static final Logger LOGGER = Logger.getLogger("oracle.iot.client");

    private ResourceMessage(Builder builder) {
        super(builder);
        if (builder.endpointName == null || builder.endpointName.length() == 0 || builder.resources.isEmpty() && builder.type == Type.UPDATE) {
            throw new IllegalArgumentException("ResourceMessage resources cannot be empty.");
        }
        this.endpointName = builder.endpointName;
        this.resources = new ArrayList(builder.resources);
        this.type = builder.type;
        this.reconciliationMark = builder.reconciliationMark == null ? "" : builder.reconciliationMark;
    }

    public static String getMD5ofList(List<String> resStrings) {
        TreeSet<Object> resCol = new TreeSet<Object>(Collator.getInstance());
        resCol.addAll(resStrings);
        String[] ordered = new String[resCol.size()];
        resCol.toArray(ordered);
        try {
            MessageDigest dg = MessageDigest.getInstance("MD5");
            for (String s : ordered) {
                dg.update(s.getBytes("UTF-8"));
            }
            byte[] hashedBytes = dg.digest();
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < hashedBytes.length; ++i) {
                sb.append(Integer.toHexString(hashedBytes[i] & 0xFF | 0x100).substring(1, 3));
            }
            return sb.toString();
        }
        catch (NoSuchAlgorithmException e) {
            ResourceMessage.getLogger().log(Level.SEVERE, e.getMessage());
        }
        catch (UnsupportedEncodingException e) {
            ResourceMessage.getLogger().log(Level.SEVERE, e.getMessage());
        }
        return null;
    }

    @Override
    public String toString() {
        return this.toJson().toString();
    }

    @Override
    public JSONObject toJson() {
        JSONObject jsonObject = Message.Utils.commonFieldsToJson(this);
        JSONObject payload = new JSONObject();
        JSONObject value = new JSONObject();
        JSONArray resource = new JSONArray();
        try {
            jsonObject.put("type", (Object)Message.Type.RESOURCE.alias());
            payload.put("type", (Object)"JSON");
            value.put("reportType", (Object)this.type.name());
            if (this.reconciliationMark != null && this.reconciliationMark.length() != 0) {
                value.put("reconciliationMark", (Object)this.reconciliationMark);
            }
            value.put("endpointName", (Object)this.endpointName);
            for (Resource r : this.resources) {
                resource.put((Object)r.toJson());
            }
            value.put("resources", (Object)resource);
            payload.put("value", (Object)value);
            jsonObject.put("payload", (Object)payload);
        }
        catch (JSONException e) {
            throw new MessageParsingException(e);
        }
        return jsonObject;
    }

    @Override
    public Message.Type getType() {
        return Message.Type.RESOURCE;
    }

    public List<Resource> getResources() {
        return this.resources;
    }

    public Type getMessageType() {
        return this.type;
    }

    public String getReconciliationMark() {
        return this.reconciliationMark;
    }

    public String getEndpointName() {
        return this.endpointName;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ResourceMessage that = (ResourceMessage)o;
        if (!this.type.equals((Object)that.type)) {
            return false;
        }
        if (!this.resources.equals(that.resources)) {
            return false;
        }
        return this.reconciliationMark.equals(that.reconciliationMark);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + this.type.hashCode();
        result = 31 * result + this.resources.hashCode();
        return result;
    }

    private static Logger getLogger() {
        return LOGGER;
    }

    public static class ReportResponse {
        private String endpointName;
        private ResponseStatus status;

        private ReportResponse(Builder builder) {
            if (builder.endpointName == null || builder.endpointName.length() == 0) {
                throw new IllegalArgumentException("Resource name, path cannot be null or empty.");
            }
            this.endpointName = builder.endpointName;
            this.status = builder.status != null ? builder.status : ResponseStatus.OK;
        }

        public JSONObject toJson() {
            JSONObject res = new JSONObject();
            try {
                res.put("endpointName", (Object)this.endpointName);
                if (this.status != null) {
                    res.put("status", (Object)this.status.name());
                } else {
                    res.put("status", (Object)ResponseStatus.OK.name());
                }
            }
            catch (JSONException e) {
                throw new RuntimeException(e);
            }
            return res;
        }

        public String getEndpointName() {
            return this.endpointName;
        }

        public ResponseStatus getStatus() {
            return this.status;
        }

        public String toString() {
            return this.toJson().toString();
        }

        public static final class Builder {
            private String endpointName;
            private ResponseStatus status;

            public Builder endpointName(String endpointName) {
                this.endpointName = endpointName;
                return this;
            }

            public Builder status(ResponseStatus status) {
                this.status = status;
                return this;
            }

            public final Builder fromString(String str) {
                if (str == null || str.length() == 0) {
                    return this;
                }
                try {
                    return this.fromJson(new JSONObject(str));
                }
                catch (JSONException e) {
                    throw new MessageParsingException(e);
                }
            }

            public final Builder fromJson(JSONObject resObject) {
                String endpointName;
                String st = resObject.optString("status", null);
                if (st != null) {
                    ResponseStatus responseStatus = st.equals("OK") ? ResponseStatus.OK : (this.status = st.equals("BAD_REPORT") ? ResponseStatus.BAD_REPORT : ResponseStatus.RECONCILIATION);
                }
                if ((endpointName = resObject.optString("endpointName", null)) == null) {
                    throw new MessageParsingException("ResourceMessage fromJson: endpointName must not be null");
                }
                this.endpointName = endpointName;
                return this;
            }

            public ReportResponse build() {
                return new ReportResponse(this);
            }
        }

        public static enum ResponseStatus {
            OK,
            BAD_REPORT,
            RECONCILIATION;

        }
    }

    public static final class Builder
    extends Message.MessageBuilder<Builder> {
        private ArrayList<Resource> resources = new ArrayList();
        private Type type = Type.UPDATE;
        private String endpointName = null;
        private String reconciliationMark = "";

        public final Builder delete() {
            this.type = Type.DELETE;
            if (!this.resources.isEmpty()) {
                this.resources.clear();
            }
            return this.self();
        }

        public final Builder register(Resource ri) {
            this.type = Type.UPDATE;
            this.resources.add(ri);
            return this.self();
        }

        public final Builder remove(Resource ri) {
            this.type = Type.DELETE;
            this.resources.add(ri);
            return this.self();
        }

        public final Builder add(Resource ri) {
            this.type = Type.UPDATE;
            this.resources.add(ri);
            return this.self();
        }

        public final Builder resources(List<Resource> resources) {
            this.type = Type.UPDATE;
            this.resources.addAll(resources);
            return this.self();
        }

        public final Builder reconciliationMark(String rM) {
            this.reconciliationMark = rM;
            return this.self();
        }

        public final Builder endpointName(String endpointName) {
            this.endpointName = endpointName;
            return this.self();
        }

        public final Builder reconcile() {
            this.type = Type.RECONCILIATION;
            return this.self();
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public ResourceMessage build() {
            return new ResourceMessage(this);
        }

        @Override
        public final Builder fromJson(JSONObject jsonObject) {
            super.fromJson(jsonObject);
            try {
                JSONObject payload = (JSONObject)jsonObject.opt("payload");
                JSONObject payloadValue = (JSONObject)payload.opt("value");
                String rt = payloadValue.getString("reportType");
                this.type = Type.valueOf(Type.class, rt);
                this.reconciliationMark = payloadValue.optString("reconciliationMark", null);
                this.endpointName = payloadValue.optString("endpointName", null);
                JSONArray resArray = (JSONArray)payloadValue.opt("resources");
                if (resArray != null) {
                    int size = resArray.length();
                    for (int i = 0; i < size; ++i) {
                        JSONObject res = (JSONObject)resArray.opt(i);
                        this.resources.add(new Resource.Builder().fromJson(res).build());
                    }
                }
            }
            catch (JSONException e) {
                throw new MessageParsingException(e);
            }
            return this.self();
        }
    }

    public static enum Type {
        UPDATE,
        DELETE,
        RECONCILIATION;

    }
}

