/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.iot.client.impl.http;

import com.oracle.iot.client.HttpResponse;
import com.oracle.iot.client.RestApi;
import com.oracle.iot.client.message.Message;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.SocketException;
import java.net.URL;
import java.security.GeneralSecurityException;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.GZIPInputStream;
import java.util.zip.InflaterInputStream;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLSocketFactory;
import oracle.iot.client.enterprise.UserAuthenticationException;

public abstract class HttpClient {
    private final URL url;
    private static final int DEFAULT_RESPONSE_TIMEOUT = 15000;
    private static final int responseTimeout;
    static Transport transport;
    private final SSLSocketFactory sslSocketFactory;
    private static final Logger LOGGER;

    public static int getResponseTimeout() {
        return responseTimeout;
    }

    protected HttpClient(SSLSocketFactory sslSocketFactory, String url) throws MalformedURLException {
        this(sslSocketFactory, new URL(url));
    }

    protected HttpClient(SSLSocketFactory sslSocketFactory, URL url) {
        if (url == null) {
            throw new IllegalArgumentException("url cannot be null");
        }
        this.url = url;
        this.sslSocketFactory = sslSocketFactory;
    }

    public final HttpResponse post(byte[] data, Map<String, String> headers) throws IOException, GeneralSecurityException {
        return this.post(data, headers, HttpClient.getResponseTimeout());
    }

    public final HttpResponse post(byte[] data, Map<String, String> headers, int timeout) throws IOException, GeneralSecurityException {
        if (timeout < 0) {
            timeout = HttpClient.getResponseTimeout();
        }
        return transport.invokeMethod("POST", this.sslSocketFactory, data, headers, this.url, timeout);
    }

    public final HttpResponse put(byte[] data, Map<String, String> headers) throws IOException, GeneralSecurityException {
        return transport.invokeMethod("PUT", this.sslSocketFactory, data, headers, this.url, HttpClient.getResponseTimeout());
    }

    public final HttpResponse get(Map<String, String> headers) throws IOException, GeneralSecurityException {
        return transport.invokeMethod("GET", this.sslSocketFactory, null, headers, this.url, HttpClient.getResponseTimeout());
    }

    public final HttpResponse delete(Map<String, String> headers) throws IOException, GeneralSecurityException {
        return transport.invokeMethod("DELETE", this.sslSocketFactory, null, headers, this.url, HttpClient.getResponseTimeout());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void pipe(InputStream in, OutputStream out) throws IOException {
        try {
            if (in != null && out != null) {
                int length;
                byte[] buffer = new byte[8096];
                while ((length = in.read(buffer)) != -1) {
                    out.write(buffer, 0, length);
                }
            }
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException ioe) {}
            }
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    protected static byte[] getResponseBody(HttpURLConnection http, InputStream responseStream) throws IOException {
        String contentEncoding = http.getContentEncoding();
        if ("gzip".equals(contentEncoding)) {
            responseStream = new GZIPInputStream(responseStream);
        } else if ("deflate".equals(contentEncoding)) {
            responseStream = new InflaterInputStream(responseStream);
        }
        ByteArrayOutputStream body = new ByteArrayOutputStream();
        HttpClient.pipe(responseStream, body);
        return body.toByteArray();
    }

    private static Logger getLogger() {
        return LOGGER;
    }

    static {
        int value = 15000;
        try {
            value = Integer.getInteger("oracle.iot.client.http_response_timeout", 15000);
            responseTimeout = value > 0 ? value : 0;
        }
        catch (SecurityException e) {
            try {
                value = 15000;
                responseTimeout = value > 0 ? value : 0;
            }
            catch (Throwable throwable) {
                responseTimeout = value > 0 ? value : 0;
                throw throwable;
            }
        }
        LOGGER = Logger.getLogger("oracle.iot.client");
    }

    public static class Transport {
        public HttpResponse invokeMethod(String method, SSLSocketFactory sslSocketFactory, byte[] data, Map<String, String> headers, URL url, int timeout) throws IOException, GeneralSecurityException {
            HttpsURLConnection con = null;
            HttpResponse response = null;
            int retries = 0;
            while (retries < 2) {
                try {
                    con = (HttpsURLConnection)url.openConnection();
                    con.setSSLSocketFactory(sslSocketFactory);
                    if (RestApi.V2.isWebApi()) {
                        con.setInstanceFollowRedirects(false);
                    } else {
                        con.setInstanceFollowRedirects(true);
                    }
                    con.setConnectTimeout(timeout);
                    con.setReadTimeout(timeout);
                    con.setRequestMethod(method);
                    if (headers != null) {
                        for (Map.Entry<String, String> entry : headers.entrySet()) {
                            con.setRequestProperty(entry.getKey(), entry.getValue());
                        }
                    }
                    this.beforeConnect(con);
                    if (data != null) {
                        con.setDoOutput(true);
                        con.setFixedLengthStreamingMode(data.length);
                    }
                    con.connect();
                    if (data != null) {
                        HttpClient.pipe(new ByteArrayInputStream(data), con.getOutputStream());
                    }
                    int responseCode = con.getResponseCode();
                    if (RestApi.V2.isWebApi() && (responseCode == 302 || responseCode == 301)) {
                        throw new UserAuthenticationException("User Authentication failed!", con.getHeaderField("Location"));
                    }
                    Map<String, List<String>> responseHeaders = con.getHeaderFields();
                    byte[] responseData = HttpClient.getResponseBody(con, responseCode >= 200 && responseCode < 300 ? con.getInputStream() : con.getErrorStream());
                    response = new HttpResponse(responseCode, responseData, responseHeaders);
                    break;
                }
                catch (SocketException se) {
                    if (++retries == 1) {
                        HttpClient.getLogger().log(Level.FINE, "Received '" + se.toString() + "'. Retry " + method + " " + url.getPath());
                        continue;
                    }
                    throw se;
                }
            }
            if (HttpClient.getLogger().isLoggable(Level.FINE)) {
                StringBuilder builder = new StringBuilder();
                builder.append(method).append(' ').append(url.getPath()).append(' ');
                if (data != null) {
                    builder.append(Message.prettyPrintJson(data));
                }
                builder.append(" => response: ").append(response);
                HttpClient.getLogger().log(Level.FINE, builder.toString());
            }
            return response;
        }

        protected void beforeConnect(HttpsURLConnection connection) throws IOException, GeneralSecurityException {
        }
    }
}

