/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.iot.client.impl.device.mqtt;

import com.oracle.iot.client.HttpResponse;
import com.oracle.iot.client.impl.device.mqtt.MqttCredentials;
import com.oracle.iot.client.impl.device.mqtt.MqttSecureConnection;
import com.oracle.iot.client.impl.device.mqtt.MqttSendReceiveImpl;
import com.oracle.iot.client.message.Message;
import com.oracle.iot.client.message.StatusCode;
import com.oracle.iot.client.trust.TrustException;
import com.oracle.iot.client.trust.TrustedAssetsManager;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.nio.charset.Charset;
import java.security.GeneralSecurityException;
import java.security.cert.CertPath;
import java.security.cert.CertPathValidator;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.PKIXParameters;
import java.security.cert.TrustAnchor;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Locale;
import java.util.Vector;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.Level;
import javax.net.SocketFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import org.eclipse.paho.client.mqttv3.IMqttDeliveryToken;
import org.eclipse.paho.client.mqttv3.MqttCallback;
import org.eclipse.paho.client.mqttv3.MqttClient;
import org.eclipse.paho.client.mqttv3.MqttClientPersistence;
import org.eclipse.paho.client.mqttv3.MqttConnectOptions;
import org.eclipse.paho.client.mqttv3.MqttException;
import org.eclipse.paho.client.mqttv3.MqttMessage;
import org.eclipse.paho.client.mqttv3.MqttSecurityException;
import org.eclipse.paho.client.mqttv3.persist.MemoryPersistence;
import org.json.JSONException;
import org.json.JSONObject;

public class MqttSecureConnectionImpl
extends MqttSecureConnection
implements MqttCallback {
    private static final String MQTT_CONNECTION_TIMEOUT_PROPERTY = "oracle.iot.client.device.mqtt_connection_timeout";
    private static final int MQTT_CONNECTION_TIMEOUT;
    private static final String MQTT_KEEP_ALIVE_INTERVAL_PROPERTY = "oracle.iot.client.device.mqtt_keep_alive_interval";
    private static final int MQTT_KEEP_ALIVE_INTERVAL;
    private static final String SEND_MESSAGE_QOS_PROPERTY = "oracle.iot.client.device.send_message_qos";
    private static final int SEND_MESSAGE_QOS_DEFAULT = 1;
    private static final int SEND_MESSAGE_QOS;
    private static final String TIME_TO_WAIT_PROPERTY = "oracle.iot.client.device.mqtt_time_to_wait";
    private static final int TIME_TO_WAIT_DEFAULT = 1000;
    private static final int TIME_TO_WAIT;
    private static final int PAHO_QUIECENSE_TIMEOUT = 0;
    private static final int PAHO_DISCONNECT_TIMEOUT = 10000;
    private static final boolean checkTLSRevocation;
    private static final Charset UTF_8;
    private MqttClient mqttClient;
    private final AtomicReference<MqttSendReceiveImpl> mqttSendReceiveImpl = new AtomicReference();
    private final AtomicReference<String> expectedTopic = new AtomicReference();
    private HttpResponse publishResponse;
    private final Object LOCK = new int[0];
    private final AtomicBoolean connectionWasLost = new AtomicBoolean(false);

    public MqttSecureConnectionImpl(TrustedAssetsManager tam, boolean isGateway) throws GeneralSecurityException {
        super(tam, false);
        try {
            this.checkConnection();
        }
        catch (MqttException e) {
            throw new GeneralSecurityException(e.getMessage(), e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void disconnect() {
        MqttSecureConnectionImpl mqttSecureConnectionImpl = this;
        synchronized (mqttSecureConnectionImpl) {
            if (this.mqttClient == null) return;
            try {
                if (!this.mqttClient.isConnected()) return;
                MqttSendReceiveImpl mqttSendReceive = this.mqttSendReceiveImpl.get();
                if (mqttSendReceive != null) {
                    try {
                        String[] topicFilters = mqttSendReceive.getSubscribeTo();
                        this.mqttClient.unsubscribe(topicFilters);
                    }
                    catch (MqttException ignored) {
                        MqttSecureConnection.getLogger().log(Level.FINE, ignored.getMessage());
                    }
                }
                this.mqttClient.disconnect();
            }
            catch (MqttException e) {
                MqttSecureConnection.getLogger().log(Level.FINE, e.getMessage());
            }
            finally {
                try {
                    this.mqttClient.close();
                }
                catch (MqttException e) {
                    MqttSecureConnection.getLogger().log(Level.INFO, e.getMessage());
                }
                finally {
                    this.mqttClient = null;
                }
            }
            return;
        }
    }

    void setMqttSendReceiveImpl(MqttSendReceiveImpl mqttSendReceiveImpl) {
        this.mqttSendReceiveImpl.set(mqttSendReceiveImpl);
        if (this.mqttClient != null && this.mqttClient.isConnected()) {
            try {
                String[] topicFilters = mqttSendReceiveImpl.getSubscribeTo();
                int[] qos = mqttSendReceiveImpl.getSubscribeQos();
                this.mqttClient.subscribe(topicFilters, qos);
            }
            catch (MqttException ignored) {
                MqttSecureConnection.getLogger().log(Level.FINE, ignored.getMessage());
            }
        }
    }

    @Override
    protected synchronized HttpResponse publish(String topic, byte[] payload, String expect) throws IOException, GeneralSecurityException {
        boolean waitForResponse = expect != null;
        int qos = waitForResponse ? 1 : SEND_MESSAGE_QOS;
        MqttMessage message = new MqttMessage();
        if (payload != null) {
            message.setPayload(payload);
        }
        message.setQos(qos);
        message.setRetained(false);
        try {
            this.checkConnection();
            if (MqttSecureConnection.getLogger().isLoggable(Level.FINE)) {
                MqttSecureConnection.getLogger().log(Level.FINE, "publish: " + topic + ", expect: " + expect);
            }
            if (MqttSecureConnection.getLogger().isLoggable(Level.FINER)) {
                MqttSecureConnection.getLogger().log(Level.FINER, "data: " + Message.prettyPrintJson(payload));
            }
            if (waitForResponse) {
                this.waitForResponse(topic, message, expect);
            } else {
                this.mqttClient.publish(topic, message);
                this.publishResponse = MqttSendReceiveImpl.ACCEPTED;
            }
            if (this.publishResponse != null) {
                int status;
                if (MqttSecureConnection.getLogger().isLoggable(Level.FINE)) {
                    MqttSecureConnection.getLogger().log(Level.FINE, "publishResponse: " + this.publishResponse.getVerboseStatus("publish", topic));
                }
                if ((status = this.publishResponse.getStatus()) == 401 || status == 403) {
                    this.disconnectForcibly();
                }
                return this.publishResponse;
            }
            MqttSecureConnection.getLogger().log(Level.SEVERE, "publishResponse == null! " + topic + ", expect " + expect);
            return new HttpResponse(StatusCode.OTHER.getCode(), "publishResponse == null!".getBytes(UTF_8), null);
        }
        catch (MqttException e) {
            this.disconnectForcibly();
            MqttSecureConnection.getLogger().log(Level.SEVERE, e.getMessage());
            throw new IOException(e.getMessage(), e);
        }
    }

    private void retryConnect(MqttConnectOptions mqttConnectOptions, MqttSecurityException mqttException) throws MqttException, GeneralSecurityException, TrustException {
        if (mqttException.getReasonCode() != 4) {
            throw mqttException;
        }
        try {
            this.trustedAssetsManager.getPublicKey();
        }
        catch (IllegalStateException ise) {
            throw mqttException;
        }
        char[] password = MqttCredentials.getClientAssertionCredentials(this.trustedAssetsManager, mqttConnectOptions.getUserName(), false);
        mqttConnectOptions.setPassword(password);
        this.mqttClient.connect(mqttConnectOptions);
        this.trustedAssetsManager.setEndPointCredentials(mqttConnectOptions.getUserName(), this.trustedAssetsManager.getEndpointCertificate());
    }

    private void checkConnection() throws MqttException, GeneralSecurityException {
        String scheme;
        if (this.mqttClient == null) {
            MemoryPersistence mqttClientPersistence = new MemoryPersistence();
            String host = this.trustedAssetsManager.getServerHost();
            int port = this.trustedAssetsManager.getServerPort();
            scheme = this.trustedAssetsManager.getServerScheme().toLowerCase(Locale.ROOT);
            String protocol = "mqtt-wss".equals(scheme) ? "wss" : ("mqtt".equals(scheme) ? "tcp" : ("mqtt-ws".equals(scheme) ? "ws" : "ssl"));
            String mqttBrokerUrl = String.format(Locale.ROOT, "%1$s://%2$s:%3$d", protocol, host, port);
            String deviceId = this.trustedAssetsManager.isActivated() ? this.trustedAssetsManager.getEndpointId() : this.trustedAssetsManager.getClientId();
            this.mqttClient = new MqttClient(mqttBrokerUrl, deviceId, (MqttClientPersistence)mqttClientPersistence);
            this.mqttClient.setCallback((MqttCallback)this);
        }
        if (!this.mqttClient.isConnected()) {
            String deviceId = this.trustedAssetsManager.isActivated() ? this.trustedAssetsManager.getEndpointId() : this.trustedAssetsManager.getClientId();
            MqttConnectOptions mqttConnectOptions = new MqttConnectOptions();
            mqttConnectOptions.setUserName(deviceId);
            char[] password = MqttCredentials.getClientAssertionCredentials(this.trustedAssetsManager);
            mqttConnectOptions.setPassword(password);
            mqttConnectOptions.setCleanSession(true);
            mqttConnectOptions.setConnectionTimeout(MQTT_CONNECTION_TIMEOUT);
            mqttConnectOptions.setKeepAliveInterval(MQTT_KEEP_ALIVE_INTERVAL);
            scheme = this.trustedAssetsManager.getServerScheme().toLowerCase(Locale.ROOT);
            if ("mqtts".equals(scheme) || "mqtt-wss".equals(scheme)) {
                SSLSocketFactory ssf = MqttSecureConnectionImpl.getSocketFactory(this.trustedAssetsManager);
                mqttConnectOptions.setSocketFactory((SocketFactory)ssf);
            }
            this.mqttClient.setCallback((MqttCallback)this);
            if (this.connectionWasLost.get() && MqttSecureConnection.getLogger().isLoggable(Level.INFO)) {
                String host = this.trustedAssetsManager.getServerHost();
                String protocol = this.trustedAssetsManager.getServerScheme();
                int port = this.trustedAssetsManager.getServerPort();
                String id = this.trustedAssetsManager.isActivated() ? this.trustedAssetsManager.getEndpointId() : this.trustedAssetsManager.getClientId();
                String msg = String.format(Locale.ROOT, "connect %1$s to %2$s://%3$s:%4$d", id, protocol, host, port);
                MqttSecureConnection.getLogger().log(Level.INFO, msg);
            }
            try {
                this.mqttClient.connect(mqttConnectOptions);
            }
            catch (MqttSecurityException se) {
                if (se.getCause() instanceof GeneralSecurityException) {
                    throw (GeneralSecurityException)se.getCause();
                }
                this.retryConnect(mqttConnectOptions, se);
            }
            this.connectionWasLost.set(false);
            MqttSendReceiveImpl mqttSendReceive = this.mqttSendReceiveImpl.get();
            if (mqttSendReceive != null) {
                String[] topicFilters = mqttSendReceive.getSubscribeTo();
                int[] qos = mqttSendReceive.getSubscribeQos();
                try {
                    this.mqttClient.subscribe(topicFilters, qos);
                }
                catch (MqttException ignored) {
                    MqttSecureConnection.getLogger().log(Level.FINE, ignored.getMessage());
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void waitForResponse(String topic, MqttMessage message, String expect) throws IOException, MqttException {
        String[] topicFilters = new String[]{expect, expect.concat("/error")};
        this.publishResponse = null;
        assert (this.expectedTopic.get() == null);
        this.expectedTopic.set(expect);
        try {
            if (!topic.endsWith("messages")) {
                this.mqttClient.subscribe(topicFilters, new int[]{1, 1});
            }
            this.mqttClient.publish(topic, message);
            Object object = this.LOCK;
            synchronized (object) {
                if (this.publishResponse == null) {
                    this.LOCK.wait(TIME_TO_WAIT);
                }
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        finally {
            this.expectedTopic.set(null);
            if (this.mqttClient.isConnected() && !topic.endsWith("messages")) {
                try {
                    this.mqttClient.unsubscribe(topicFilters);
                }
                catch (MqttException ignored) {
                    MqttSecureConnection.getLogger().log(Level.FINE, ignored.getMessage());
                }
            }
        }
        if (this.publishResponse == null) {
            if (this.mqttClient.isConnected()) {
                this.disconnectForcibly();
            }
            this.connectionWasLost.set(true);
            throw new IOException("Timed out waiting for a response from the server");
        }
    }

    public void connectionLost(Throwable throwable) {
        MqttSecureConnection.getLogger().log(Level.INFO, throwable.getMessage());
        this.connectionWasLost.set(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void messageArrived(String topic, MqttMessage mqttMessage) throws Exception {
        boolean isExpected;
        String expected = this.expectedTopic.get();
        boolean bl = isExpected = expected != null && topic.startsWith(expected);
        if (MqttSecureConnection.getLogger().isLoggable(Level.FINE)) {
            MqttSecureConnection.getLogger().log(Level.FINE, "messageArrived for topic: " + topic + ", expected: " + expected);
        }
        if (!isExpected) {
            MqttSecureConnection.getLogger().log(Level.SEVERE, "Message for '" + topic + "' not expected. " + "Expected '" + this.expectedTopic.get() + "'");
            throw new MqttException(0);
        }
        HttpResponse httpResponse = null;
        MqttSendReceiveImpl sendReceive = this.mqttSendReceiveImpl.get();
        if (sendReceive != null) {
            httpResponse = sendReceive.handleMessage(topic, mqttMessage);
        }
        if (httpResponse == null) {
            byte[] payload = mqttMessage.getPayload();
            boolean isError = topic.endsWith("/error");
            httpResponse = !isError ? new HttpResponse(StatusCode.OK.getCode(), payload, null) : MqttSecureConnectionImpl.getErrorResponse(payload);
        }
        Object object = this.LOCK;
        synchronized (object) {
            this.publishResponse = httpResponse;
            this.LOCK.notifyAll();
            return;
        }
    }

    public void deliveryComplete(IMqttDeliveryToken iMqttDeliveryToken) {
        if (iMqttDeliveryToken.getException() != null) {
            MqttSecureConnection.getLogger().log(Level.INFO, iMqttDeliveryToken.getException().getMessage());
        }
    }

    static HttpResponse getErrorResponse(byte[] payload) {
        try {
            String json = new String(payload, UTF_8);
            JSONObject jsonObject = new JSONObject(json);
            int code = jsonObject.getInt("status");
            return new HttpResponse(code, jsonObject.toString().getBytes(UTF_8), null);
        }
        catch (JSONException e) {
            MqttSecureConnection.getLogger().log(Level.SEVERE, e.getMessage() + ": " + new String(payload, UTF_8));
            return new HttpResponse(StatusCode.OTHER.getCode(), e.getMessage().getBytes(UTF_8), null);
        }
    }

    private static SSLSocketFactory getSocketFactory(TrustedAssetsManager trustedAssetsManager) throws GeneralSecurityException {
        SSLContext sslContext = SSLContext.getInstance("TLS");
        CertificateFactory factory = CertificateFactory.getInstance("X.509");
        Vector<byte[]> certs = trustedAssetsManager.getTrustAnchorCertificates();
        if (certs == null) {
            sslContext.init(null, null, null);
            return sslContext.getSocketFactory();
        }
        final HashSet<TrustAnchor> trustAnchors = new HashSet<TrustAnchor>();
        for (int i = 0; i < certs.size(); ++i) {
            TrustAnchor trustAnchor = new TrustAnchor((X509Certificate)factory.generateCertificate(new ByteArrayInputStream(certs.elementAt(i))), null);
            trustAnchors.add(trustAnchor);
        }
        sslContext.init(null, new TrustManager[]{new X509TrustManager(){

            @Override
            public void checkClientTrusted(X509Certificate[] certificates, String authType) throws CertificateException {
                throw new CertificateException();
            }

            @Override
            public void checkServerTrusted(X509Certificate[] certificates, String authType) throws CertificateException {
                CertificateFactory factory = CertificateFactory.getInstance("X.509");
                CertPath chain = factory.generateCertPath(Arrays.asList(certificates));
                try {
                    PKIXParameters params = new PKIXParameters(trustAnchors);
                    params.setRevocationEnabled(checkTLSRevocation);
                    CertPathValidator validator = CertPathValidator.getInstance("PKIX");
                    validator.validate(chain, params);
                }
                catch (Exception e) {
                    throw new CertificateException(e);
                }
            }

            @Override
            public X509Certificate[] getAcceptedIssuers() {
                return null;
            }
        }}, null);
        return sslContext.getSocketFactory();
    }

    private void disconnectForcibly() {
        try {
            try {
                this.mqttClient.disconnectForcibly(0L, 10000L);
            }
            catch (Exception exception) {
                MqttSecureConnection.getLogger().log(Level.FINE, exception.getMessage());
            }
            finally {
                this.mqttClient.close();
            }
        }
        catch (MqttException ignored) {
            MqttSecureConnection.getLogger().log(Level.FINE, ignored.getMessage());
        }
        finally {
            this.mqttClient = null;
            this.connectionWasLost.set(true);
        }
    }

    static {
        int val = Integer.getInteger(MQTT_CONNECTION_TIMEOUT_PROPERTY, 30);
        MQTT_CONNECTION_TIMEOUT = 0 <= val ? val : 30;
        val = Integer.getInteger(MQTT_KEEP_ALIVE_INTERVAL_PROPERTY, 60);
        MQTT_KEEP_ALIVE_INTERVAL = 0 <= val ? val : 60;
        val = Integer.getInteger(SEND_MESSAGE_QOS_PROPERTY, 1);
        SEND_MESSAGE_QOS = 0 <= val && val <= 2 ? val : 1;
        val = Integer.getInteger(TIME_TO_WAIT_PROPERTY, 1000);
        TIME_TO_WAIT = 0 <= val ? val : 0;
        checkTLSRevocation = Boolean.getBoolean("com.sun.net.ssl.checkRevocation");
        UTF_8 = Charset.forName("UTF-8");
    }
}

