/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.iot.client.impl.device;

import com.oracle.iot.client.DeviceModelAction;
import com.oracle.iot.client.DeviceModelAttribute;
import com.oracle.iot.client.StorageObject;
import com.oracle.iot.client.VirtualDeviceAttribute;
import com.oracle.iot.client.device.DirectlyConnectedDevice;
import com.oracle.iot.client.device.util.MessageDispatcher;
import com.oracle.iot.client.device.util.RequestDispatcher;
import com.oracle.iot.client.device.util.RequestHandler;
import com.oracle.iot.client.impl.DeviceModelImpl;
import com.oracle.iot.client.impl.StorageConnectionBase;
import com.oracle.iot.client.impl.VirtualDeviceAttributeBase;
import com.oracle.iot.client.impl.VirtualDeviceBase;
import com.oracle.iot.client.impl.device.AlertImpl;
import com.oracle.iot.client.impl.device.DataImpl;
import com.oracle.iot.client.impl.device.MessageDispatcherImpl;
import com.oracle.iot.client.impl.device.StorageObjectImpl;
import com.oracle.iot.client.impl.device.VirtualDeviceAttributeImpl;
import com.oracle.iot.client.message.DataItem;
import com.oracle.iot.client.message.DataMessage;
import com.oracle.iot.client.message.Message;
import com.oracle.iot.client.message.RequestMessage;
import com.oracle.iot.client.message.ResponseMessage;
import com.oracle.iot.client.message.StatusCode;
import java.io.UnsupportedEncodingException;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.iot.client.AbstractVirtualDevice;
import oracle.iot.client.DeviceModel;
import oracle.iot.client.ExternalObject;
import oracle.iot.client.StorageObject;
import oracle.iot.client.device.Alert;
import oracle.iot.client.device.Data;
import oracle.iot.client.device.VirtualDevice;
import org.json.JSONException;
import org.json.JSONObject;

public final class VirtualDeviceImpl
extends VirtualDevice
implements VirtualDeviceBase.Adapter<VirtualDevice>,
RequestHandler {
    private final VirtualDeviceBase<VirtualDevice> base;
    final DirectlyConnectedDevice directlyConnectedDevice;
    private final Map<String, VirtualDeviceAttributeBase<VirtualDevice, Object>> attributeMap;
    private static final ErrorCallbackBridge ERROR_CALLBACK_BRIDGE = new ErrorCallbackBridge();
    private final Object actionMapLock = new Object();
    private volatile Map<String, VirtualDevice.Callable<?>> actionMap;
    private static final ExecutorService errorEventDispatcher = Executors.newSingleThreadExecutor(new ThreadFactory(){

        @Override
        public Thread newThread(Runnable r) {
            SecurityManager s = System.getSecurityManager();
            ThreadGroup group = s != null ? s.getThreadGroup() : Thread.currentThread().getThreadGroup();
            Thread t = new Thread(group, r, "errorEventDispatchingThread", 0L);
            if (!t.isDaemon()) {
                t.setDaemon(true);
            }
            if (t.getPriority() != 5) {
                t.setPriority(5);
            }
            return t;
        }
    });
    private static final Logger LOGGER = Logger.getLogger("oracle.iot.client");

    public VirtualDeviceImpl(DirectlyConnectedDevice directlyConnectedDevice, String endpointId, DeviceModelImpl deviceModel) {
        this.base = new VirtualDeviceBase<VirtualDevice>(this, endpointId, deviceModel);
        this.directlyConnectedDevice = directlyConnectedDevice;
        this.attributeMap = VirtualDeviceImpl.createAttributeMap(this, deviceModel);
        MessageDispatcher messageDispatcher = MessageDispatcher.getMessageDispatcher(directlyConnectedDevice);
        RequestDispatcher requestDispatcher = messageDispatcher.getRequestDispatcher();
        requestDispatcher.registerRequestHandler(endpointId, "deviceModels/" + deviceModel.getURN(), this);
        ERROR_CALLBACK_BRIDGE.add(this);
        messageDispatcher.setOnError(ERROR_CALLBACK_BRIDGE);
    }

    private static Map<String, VirtualDeviceAttributeBase<VirtualDevice, Object>> createAttributeMap(VirtualDeviceImpl virtualDevice, DeviceModel deviceModel) {
        HashMap<String, VirtualDeviceAttributeBase<VirtualDevice, Object>> map = new HashMap<String, VirtualDeviceAttributeBase<VirtualDevice, Object>>();
        if (deviceModel instanceof DeviceModelImpl) {
            DeviceModelImpl deviceModelImpl = (DeviceModelImpl)deviceModel;
            for (DeviceModelAttribute attribute : deviceModelImpl.getDeviceModelAttributes().values()) {
                VirtualDeviceAttributeImpl vda = new VirtualDeviceAttributeImpl(virtualDevice, attribute);
                map.put(attribute.getName(), vda);
                String alias = attribute.getAlias();
                if (alias == null || alias.length() == 0) continue;
                map.put(alias, vda);
            }
        }
        return map;
    }

    @Override
    public VirtualDeviceAttributeBase<VirtualDevice, Object> getAttribute(String attributeName) {
        VirtualDeviceAttributeBase<VirtualDevice, Object> virtualDeviceAttribute = this.attributeMap.get(attributeName);
        if (virtualDeviceAttribute == null) {
            throw new IllegalArgumentException("no such attribute '" + attributeName + "'.\n\tVerify that the URN for the device model you created " + "matches the URN that you use when activating the device in " + "the Java application.\n\tVerify that the attribute name " + "(and spelling) you chose for your device model matches the " + "attribute you are setting in the Java application.");
        }
        return virtualDeviceAttribute;
    }

    @Override
    public void setValue(VirtualDeviceAttributeBase<VirtualDevice, Object> attribute, Object value) {
        if (attribute == null) {
            throw new IllegalArgumentException("attribute may not be null");
        }
        attribute.set(value);
    }

    @Override
    public void updateFields(Map<VirtualDeviceAttributeBase<VirtualDevice, Object>, Object> updatedAttributes) {
        Set<Map.Entry<VirtualDeviceAttributeBase<VirtualDevice, Object>, Object>> entries = updatedAttributes.entrySet();
        for (Map.Entry<VirtualDeviceAttributeBase<VirtualDevice, Object>, Object> entry : entries) {
            VirtualDeviceAttributeBase<VirtualDevice, Object> attribute = entry.getKey();
            Object value = entry.getValue();
            try {
                attribute.update(value);
            }
            catch (Exception e) {}
        }
        this.processOnChange(updatedAttributes);
    }

    @Override
    public DeviceModel getDeviceModel() {
        return this.base.getDeviceModel();
    }

    @Override
    public String getEndpointId() {
        return this.base.getEndpointId();
    }

    @Override
    public <T> T get(String attributeName) {
        VirtualDeviceAttributeBase<VirtualDevice, Object> attribute = this.getAttribute(attributeName);
        return (T)attribute.get();
    }

    @Override
    public <T> T getLastKnown(String attributeName) {
        VirtualDeviceAttributeBase<VirtualDevice, Object> attribute = this.getAttribute(attributeName);
        return (T)attribute.getLastKnown();
    }

    @Override
    public <T> VirtualDevice set(String attributeName, T value) {
        this.base.set(attributeName, value);
        return this;
    }

    @Override
    public VirtualDevice update() {
        this.base.update();
        return this;
    }

    @Override
    public void finish() {
        this.base.finish();
    }

    @Override
    public void setOnChange(String attributeName, AbstractVirtualDevice.ChangeCallback callback) {
        VirtualDeviceAttributeBase<VirtualDevice, Object> attribute = this.getAttribute(attributeName);
        ((VirtualDeviceAttribute)attribute).setOnChange(callback);
    }

    @Override
    public void setOnChange(AbstractVirtualDevice.ChangeCallback callback) {
        this.base.setOnChange(callback);
    }

    AbstractVirtualDevice.ChangeCallback getChangeCallback() {
        return this.base.getOnChangeCallback();
    }

    @Override
    public void setOnError(AbstractVirtualDevice.ErrorCallback callback) {
        this.base.setOnError(callback);
    }

    AbstractVirtualDevice.ErrorCallback getErrorCallback() {
        return this.base.getOnErrorCallback();
    }

    @Override
    public void setOnError(String attributeName, AbstractVirtualDevice.ErrorCallback<VirtualDevice> callback) {
        VirtualDeviceAttributeBase<VirtualDevice, Object> attribute = this.getAttribute(attributeName);
        ((VirtualDeviceAttribute)attribute).setOnError(callback);
    }

    @Override
    public ResponseMessage handleRequest(RequestMessage requestMessage) throws Exception {
        String method = requestMessage.getMethod().toUpperCase(Locale.ROOT);
        StatusCode responseStatus = StatusCode.BAD_REQUEST;
        if ("POST".equals(method)) {
            String methodOverride = requestMessage.getHeaderValue("X-HTTP-Method-Override");
            responseStatus = "PATCH".equalsIgnoreCase(methodOverride) ? this.handlePatch(requestMessage) : this.handlePost(requestMessage);
        } else if ("PUT".equals(method)) {
            responseStatus = this.handlePut(requestMessage);
        } else if ("PATCH".equals(method)) {
            responseStatus = this.handlePatch(requestMessage);
        } else {
            VirtualDeviceImpl.getLogger().severe("unexpected method: " + method);
        }
        return new ResponseMessage.Builder(requestMessage).statusCode(responseStatus).build();
    }

    private StatusCode handlePatch(RequestMessage requestMessage) {
        VirtualDeviceBase.NamedValueImpl<Object> root = null;
        VirtualDeviceBase.NamedValueImpl<Object> last = null;
        try {
            VirtualDeviceAttributeImpl attribute;
            Object jsonValue;
            String attributeName;
            Iterator keys;
            byte[] rawData = requestMessage.getBody();
            String json = new String(rawData, "UTF-8");
            JSONObject jsonObject = new JSONObject(json);
            if (this.base.getOnChangeCallback() == null) {
                keys = jsonObject.keys();
                while (keys.hasNext()) {
                    attributeName = (String)keys.next();
                    jsonValue = jsonObject.get(attributeName);
                    attribute = (VirtualDeviceAttributeImpl)this.getAttribute(attributeName);
                    if (attribute.getOnChange() != null) continue;
                    VirtualDeviceImpl.getLogger().log(Level.INFO, "No handler for: '" + requestMessage.getMethod().toUpperCase(Locale.ROOT) + " " + requestMessage.getURL());
                    return StatusCode.NOT_FOUND;
                }
            }
            keys = jsonObject.keys();
            while (keys.hasNext()) {
                attributeName = (String)keys.next();
                jsonValue = jsonObject.get(attributeName);
                attribute = (VirtualDeviceAttributeImpl)this.getAttribute(attributeName);
                DeviceModelAttribute dma = attribute.getDeviceModelAttribute();
                Object newValue = this.getValue(dma.getType(), jsonValue, attributeName);
                attribute.validate(dma, newValue);
                Object oldValue = attribute.get();
                if (oldValue != null ? oldValue.equals(newValue) : newValue == null) continue;
                VirtualDeviceBase.NamedValueImpl<Object> nameValue = new VirtualDeviceBase.NamedValueImpl<Object>(attributeName, newValue);
                if (attribute.getOnChange() != null) {
                    attribute.getOnChange().onChange(new VirtualDeviceBase.ChangeEvent<VirtualDeviceImpl>(this, nameValue));
                }
                if (last != null) {
                    last.setNext(nameValue);
                    last = nameValue;
                    continue;
                }
                root = last = nameValue;
            }
        }
        catch (Exception e) {
            VirtualDeviceImpl.getLogger().log(Level.SEVERE, e.getMessage(), e);
            return StatusCode.BAD_REQUEST;
        }
        if (root == null) {
            return StatusCode.ACCEPTED;
        }
        AbstractVirtualDevice.ChangeCallback<VirtualDevice> changeCallback = this.base.getOnChangeCallback();
        try {
            if (changeCallback != null) {
                changeCallback.onChange(new VirtualDeviceBase.ChangeEvent<VirtualDeviceImpl>(this, root));
            }
            ArrayList dataItems = new ArrayList();
            block14: for (AbstractVirtualDevice.NamedValue namedValue = root; namedValue != null; namedValue = ((AbstractVirtualDevice.NamedValue)namedValue).next()) {
                String attributeName = ((AbstractVirtualDevice.NamedValue)namedValue).getName();
                VirtualDeviceAttributeImpl attribute = (VirtualDeviceAttributeImpl)this.getAttribute(attributeName);
                Object newValue = ((AbstractVirtualDevice.NamedValue)namedValue).getValue();
                attribute.update(newValue);
                DeviceModelAttribute dma = attribute.getDeviceModelAttribute();
                switch (dma.getType()) {
                    case INTEGER: {
                        dataItems.add(new DataItem(attributeName, ((Integer)newValue).intValue()));
                        continue block14;
                    }
                    case NUMBER: {
                        dataItems.add(new DataItem(attributeName, ((Number)newValue).doubleValue()));
                        continue block14;
                    }
                    case BOOLEAN: {
                        dataItems.add(new DataItem(attributeName, (Boolean)newValue));
                        continue block14;
                    }
                    case URI: {
                        dataItems.add(new DataItem(attributeName, ((ExternalObject)newValue).getURI()));
                        continue block14;
                    }
                    case STRING: {
                        dataItems.add(new DataItem(attributeName, (String)newValue));
                        continue block14;
                    }
                    case DATETIME: {
                        dataItems.add(new DataItem(attributeName, ((Long)newValue).longValue()));
                        continue block14;
                    }
                    default: {
                        VirtualDeviceImpl.getLogger().severe("'" + (Object)((Object)dma.getType()) + "' not handled");
                    }
                }
            }
            DataMessage dataMessage = ((DataMessage.Builder)new DataMessage.Builder().format(this.getDeviceModel().getURN() + ":attributes").source(this.getEndpointId())).dataItems(dataItems).build();
            MessageDispatcher messageDispatcher = MessageDispatcher.getMessageDispatcher(this.directlyConnectedDevice);
            messageDispatcher.queue(dataMessage);
            return StatusCode.ACCEPTED;
        }
        catch (Exception e) {
            VirtualDeviceImpl.getLogger().log(Level.SEVERE, e.getMessage(), e);
            return StatusCode.INTERNAL_SERVER_ERROR;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private StatusCode handlePost(RequestMessage requestMessage) {
        VirtualDevice.Callable<?> callable;
        String actionName;
        String path = requestMessage.getURL();
        String dmURN = "deviceModels/" + this.getDeviceModel().getURN() + "/actions";
        String string = actionName = dmURN.regionMatches(0, path, 0, dmURN.length()) ? path.substring(dmURN.length() + 1) : path;
        if (this.actionMap == null) {
            callable = null;
        } else {
            Object object = this.actionMapLock;
            synchronized (object) {
                callable = this.actionMap.get(actionName);
            }
        }
        if (callable != null) {
            try {
                DeviceModelAction action = VirtualDeviceImpl.getDeviceModelAction(this.base.getDeviceModel(), actionName);
                Object data = action.getArgType() != null ? this.getValue(action.getArgType(), requestMessage.getBody(), actionName) : null;
                callable.call(this, data);
                return StatusCode.ACCEPTED;
            }
            catch (Exception e) {
                VirtualDeviceImpl.getLogger().log(Level.FINE, e.getMessage(), e);
                return StatusCode.BAD_REQUEST;
            }
        }
        VirtualDeviceImpl.getLogger().log(Level.INFO, "No handler for: '" + requestMessage.getMethod().toUpperCase(Locale.ROOT) + " " + requestMessage.getURL());
        return StatusCode.NOT_FOUND;
    }

    private StatusCode handlePut(RequestMessage requestMessage) {
        try {
            String path = requestMessage.getURL();
            String dmURN = "deviceModels/" + this.getDeviceModel().getURN() + "/attributes";
            String attributeName = dmURN.regionMatches(0, path, 0, dmURN.length()) ? path.substring(dmURN.length() + 1) : path;
            VirtualDeviceAttributeBase<VirtualDevice, Object> virtualDeviceAttribute = this.getAttribute(attributeName);
            DeviceModelAttribute<Object> deviceModelAttribute = virtualDeviceAttribute.getDeviceModelAttribute();
            DeviceModelAttribute.Type attributeType = deviceModelAttribute.getType();
            byte[] data = requestMessage.getBody();
            Object newValue = this.getValue(attributeType, data, attributeName);
            Object oldValue = virtualDeviceAttribute.get();
            if (oldValue != null ? oldValue.equals(newValue) : newValue == null) {
                return StatusCode.ACCEPTED;
            }
            VirtualDeviceBase.NamedValueImpl<Object> namedValue = new VirtualDeviceBase.NamedValueImpl<Object>(attributeName, newValue);
            boolean attrOnChangeCalled = false;
            if (virtualDeviceAttribute.getOnChange() != null) {
                virtualDeviceAttribute.getOnChange().onChange(new VirtualDeviceBase.ChangeEvent<VirtualDeviceImpl>(this, namedValue));
                attrOnChangeCalled = true;
            }
            if (this.base.getOnChangeCallback() != null) {
                this.base.getOnChangeCallback().onChange(new VirtualDeviceBase.ChangeEvent<VirtualDeviceImpl>(this, namedValue));
                attrOnChangeCalled = true;
            }
            if (attrOnChangeCalled) {
                virtualDeviceAttribute.set(newValue);
                return StatusCode.ACCEPTED;
            }
            VirtualDeviceImpl.getLogger().log(Level.INFO, "No handler for: '" + requestMessage.getMethod().toUpperCase(Locale.ROOT) + " " + requestMessage.getURL());
            return StatusCode.NOT_FOUND;
        }
        catch (Exception e) {
            VirtualDeviceImpl.getLogger().log(Level.FINE, e.getMessage(), e);
            return StatusCode.BAD_REQUEST;
        }
    }

    private static DeviceModelAction getDeviceModelAction(DeviceModelImpl deviceModel, String actionName) {
        Map<String, DeviceModelAction> actions;
        if (deviceModel != null && !(actions = deviceModel.getDeviceModelActions()).isEmpty()) {
            DeviceModelAction act = actions.get(actionName);
            if (act != null) {
                return act;
            }
            for (DeviceModelAction action : actions.values()) {
                if (!actionName.equals(action.getAlias())) continue;
                return action;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setCallable(String actionName, VirtualDevice.Callable<?> callable) {
        Map<String, DeviceModelAction> actions;
        DeviceModelAction deviceModelAction;
        if (this.actionMap == null) {
            Object object = this.actionMapLock;
            synchronized (object) {
                if (this.actionMap == null) {
                    this.actionMap = new HashMap();
                }
            }
        }
        if ((deviceModelAction = (actions = this.base.getDeviceModel().getDeviceModelActions()).get(actionName)) == null) {
            for (DeviceModelAction action : actions.values()) {
                if (!actionName.equals(action.getAlias())) continue;
                deviceModelAction = action;
                break;
            }
        }
        if (deviceModelAction == null) {
            throw new IllegalArgumentException("action not found in model");
        }
        Object object = this.actionMapLock;
        synchronized (object) {
            this.actionMap.put(deviceModelAction.getName(), callable);
            if (deviceModelAction.getAlias() != null) {
                this.actionMap.put(deviceModelAction.getAlias(), callable);
            }
        }
    }

    @Override
    public Alert createAlert(String format) {
        return new AlertImpl(this, format);
    }

    @Override
    public Data createData(String format) {
        return new DataImpl(this, format);
    }

    <T> void processOnChange(VirtualDeviceAttribute<VirtualDevice, T> virtualDeviceAttribute, Object newValue) {
        DataMessage.Builder builder = new DataMessage.Builder();
        ArrayList<StorageObjectImpl> storageObjects = new ArrayList<StorageObjectImpl>();
        try {
            this.processOnChange(builder, (VirtualDeviceAttributeImpl)virtualDeviceAttribute, newValue, storageObjects);
        }
        catch (RuntimeException re) {
            return;
        }
        DataMessage dataMessage = builder.build();
        MessageDispatcherImpl messageDispatcher = (MessageDispatcherImpl)MessageDispatcher.getMessageDispatcher(this.directlyConnectedDevice);
        try {
            for (StorageObjectImpl so : storageObjects) {
                messageDispatcher.addStorageObjectDependency(so, dataMessage.getClientId());
            }
            messageDispatcher.queue(dataMessage);
        }
        catch (ArrayStoreException e) {
            HashSet<VirtualDeviceAttributeBase<VirtualDevice, Object>> attributes = new HashSet<VirtualDeviceAttributeBase<VirtualDevice, Object>>(1);
            attributes.add((VirtualDeviceAttributeImpl)virtualDeviceAttribute);
            this.notifyException(attributes, e);
        }
        catch (Exception e) {
            VirtualDeviceImpl.getLogger().severe(e.getMessage());
        }
    }

    private void processOnChange(Map<VirtualDeviceAttributeBase<VirtualDevice, Object>, Object> updatedAttributes) {
        if (updatedAttributes.isEmpty()) {
            return;
        }
        DataMessage.Builder builder = new DataMessage.Builder();
        ArrayList<StorageObjectImpl> storageObjects = new ArrayList<StorageObjectImpl>();
        for (Map.Entry<VirtualDeviceAttributeBase<VirtualDevice, Object>, Object> entry : updatedAttributes.entrySet()) {
            VirtualDeviceAttributeBase<VirtualDevice, Object> attribute = entry.getKey();
            Object newValue = entry.getValue();
            try {
                this.processOnChange(builder, attribute, newValue, storageObjects);
            }
            catch (RuntimeException re) {
                return;
            }
        }
        DataMessage dataMessage = builder.build();
        MessageDispatcherImpl messageDispatcher = (MessageDispatcherImpl)MessageDispatcher.getMessageDispatcher(this.directlyConnectedDevice);
        try {
            for (StorageObjectImpl so : storageObjects) {
                messageDispatcher.addStorageObjectDependency(so, dataMessage.getClientId());
            }
            messageDispatcher.queue(dataMessage);
        }
        catch (ArrayStoreException e) {
            this.notifyException(updatedAttributes.keySet(), e);
        }
        catch (Exception e) {
            VirtualDeviceImpl.getLogger().severe(e.getMessage());
        }
    }

    void handleStorageObjectStateChange(StorageObjectImpl so) {
        MessageDispatcherImpl messageDispatcherImpl = (MessageDispatcherImpl)MessageDispatcher.getMessageDispatcher(this.directlyConnectedDevice);
        messageDispatcherImpl.removeStorageObjectDependency(so);
    }

    public String toString() {
        return this.base.toString();
    }

    private Object getValue(DeviceModelAttribute.Type attributeType, byte[] payload, String name) throws JSONException, IllegalArgumentException {
        String json;
        try {
            json = new String(payload, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new JSONException(e.getMessage());
        }
        JSONObject jsonObject = new JSONObject(json);
        Object jsonValue = jsonObject.opt("value");
        if (jsonValue == null) {
            throw new IllegalArgumentException("bad payload " + String.valueOf(jsonObject));
        }
        return this.getValue(attributeType, jsonValue, name);
    }

    private Object getValue(DeviceModelAttribute.Type attributeType, Object jsonValue, String name) throws IllegalArgumentException {
        if (jsonValue == null) {
            return null;
        }
        Object data = null;
        switch (attributeType) {
            case BOOLEAN: {
                if (!(jsonValue instanceof Boolean)) {
                    throw new IllegalArgumentException("value is not BOOLEAN");
                }
                data = jsonValue;
                break;
            }
            case INTEGER: {
                if (!(jsonValue instanceof Number)) {
                    throw new IllegalArgumentException("value is not NUMBER");
                }
                data = ((Number)jsonValue).intValue();
                break;
            }
            case NUMBER: {
                if (!(jsonValue instanceof Number)) {
                    throw new IllegalArgumentException("value is not NUMBER");
                }
                data = jsonValue;
                break;
            }
            case DATETIME: {
                if (!(jsonValue instanceof Number)) {
                    throw new IllegalArgumentException("value is not NUMBER");
                }
                data = ((Number)jsonValue).longValue();
                break;
            }
            case STRING: {
                if (!(jsonValue instanceof String)) {
                    throw new IllegalArgumentException("value is not STRING");
                }
                data = jsonValue;
                break;
            }
            case URI: {
                if (!(jsonValue instanceof String)) {
                    throw new IllegalArgumentException("value is not STRING");
                }
                try {
                    if (StorageConnectionBase.isStorageCloudURI((String)jsonValue)) {
                        try {
                            StorageObject delegate = this.directlyConnectedDevice.createStorageObject((String)jsonValue);
                            StorageObjectImpl storageObjectImpl = new StorageObjectImpl(this.directlyConnectedDevice, delegate);
                            storageObjectImpl.setSyncEventInfo(this, name);
                            data = storageObjectImpl;
                            break;
                        }
                        catch (Exception e) {
                            VirtualDeviceImpl.getLogger().log(Level.WARNING, "Storage CS object access failed: " + e.getMessage());
                        }
                    }
                    data = new ExternalObject((String)jsonValue);
                    break;
                }
                catch (Exception e) {
                    throw new IllegalArgumentException("Cannot get value for attribute" + name, e);
                }
            }
            default: {
                throw new IllegalArgumentException("unexpected type '" + (Object)((Object)attributeType) + "'");
            }
        }
        return data;
    }

    private void processOnChange(DataMessage.Builder builder, VirtualDeviceAttributeBase<VirtualDevice, Object> attribute, Object newValue, List<StorageObjectImpl> storageObjectList) {
        DeviceModelAttribute<Object> deviceModelAttribute = attribute.getDeviceModelAttribute();
        String attributeName = deviceModelAttribute.getName();
        builder.format(this.base.getDeviceModel().getURN() + ":attributes").source(this.base.getEndpointId());
        switch (deviceModelAttribute.getType()) {
            case INTEGER: 
            case NUMBER: {
                builder.dataItem(attributeName, ((Number)newValue).doubleValue());
                break;
            }
            case STRING: {
                builder.dataItem(attributeName, (String)newValue);
                break;
            }
            case URI: {
                if (newValue instanceof StorageObjectImpl) {
                    StorageObjectImpl storageObjectImpl = (StorageObjectImpl)newValue;
                    if (storageObjectImpl.getSyncStatus() == StorageObject.SyncStatus.NOT_IN_SYNC || storageObjectImpl.getSyncStatus() == StorageObject.SyncStatus.SYNC_PENDING) {
                        storageObjectList.add(storageObjectImpl);
                    }
                    storageObjectImpl.setSyncEventInfo(this, attributeName);
                    storageObjectImpl.sync();
                }
                builder.dataItem(attributeName, ((ExternalObject)newValue).getURI());
                break;
            }
            case BOOLEAN: {
                builder.dataItem(attributeName, (Boolean)newValue);
                break;
            }
            case DATETIME: {
                builder.dataItem(attributeName, ((Date)newValue).getTime());
                break;
            }
            default: {
                VirtualDeviceImpl.getLogger().severe("unknown attribute type " + (Object)((Object)deviceModelAttribute.getType()));
                throw new RuntimeException("unknown attribute type " + (Object)((Object)deviceModelAttribute.getType()));
            }
        }
    }

    void notifyException(Set<VirtualDeviceAttributeBase<VirtualDevice, Object>> attributes, Exception e) {
        final AbstractVirtualDevice.ErrorCallback errorCallback = this.getErrorCallback();
        if (errorCallback == null) {
            return;
        }
        VirtualDeviceBase.NamedValueImpl<Object> head = null;
        VirtualDeviceBase.NamedValueImpl<Object> tail = null;
        for (VirtualDeviceAttributeBase<VirtualDevice, Object> attribute : attributes) {
            String name = attribute.getDeviceModelAttribute().getName();
            Object value = attribute.get();
            VirtualDeviceBase.NamedValueImpl<Object> next = new VirtualDeviceBase.NamedValueImpl<Object>(name, value);
            if (head != null) {
                tail.setNext(next);
                tail = next;
                continue;
            }
            head = tail = next;
        }
        final VirtualDeviceBase.ErrorEvent<VirtualDeviceImpl> errorEvent = new VirtualDeviceBase.ErrorEvent<VirtualDeviceImpl>(this, head, e.getMessage());
        final String msg = e.getMessage();
        errorEventDispatcher.submit(new Runnable(){

            @Override
            public void run() {
                try {
                    errorCallback.onError(errorEvent);
                }
                catch (Exception ignored) {
                    VirtualDeviceImpl.getLogger().info("onError threw: " + msg);
                }
            }
        });
    }

    private static Logger getLogger() {
        return LOGGER;
    }

    private static class ErrorCallbackBridge
    implements MessageDispatcher.ErrorCallback {
        private final Map<String, WeakReference<VirtualDeviceImpl>> deviceSet = new HashMap<String, WeakReference<VirtualDeviceImpl>>();

        private ErrorCallbackBridge() {
        }

        void add(VirtualDeviceImpl virtualDevice) {
            if (this.deviceSet.size() > 0) {
                Iterator<Map.Entry<String, WeakReference<VirtualDeviceImpl>>> iterator = this.deviceSet.entrySet().iterator();
                while (iterator.hasNext()) {
                    Map.Entry<String, WeakReference<VirtualDeviceImpl>> entry = iterator.next();
                    WeakReference<VirtualDeviceImpl> ref = entry.getValue();
                    if (ref.get() != null) continue;
                    iterator.remove();
                }
            }
            assert (virtualDevice.getEndpointId() != null);
            this.deviceSet.put(virtualDevice.getEndpointId(), new WeakReference<VirtualDeviceImpl>(virtualDevice));
        }

        @Override
        public void failed(List<Message> messages, Exception exception) {
            ArrayList<Message> list;
            String source;
            HashMap<String, ArrayList<Message>> collatedMessages = new HashMap<String, ArrayList<Message>>(messages.size());
            for (Message message : messages) {
                source = message.getSource();
                list = (ArrayList<Message>)collatedMessages.get(source);
                if (list == null) {
                    list = new ArrayList<Message>();
                    collatedMessages.put(source, list);
                }
                list.add(message);
            }
            for (Map.Entry entry : collatedMessages.entrySet()) {
                VirtualDeviceImpl virtualDevice;
                source = (String)entry.getKey();
                list = (List)entry.getValue();
                WeakReference<VirtualDeviceImpl> ref = this.deviceSet.get(source);
                if (ref == null) {
                    new Exception("DEBUG source=" + source + " deviceSet=" + this.deviceSet).printStackTrace();
                }
                if ((virtualDevice = ref == null ? null : (VirtualDeviceImpl)ref.get()) == null) continue;
                this.invokeErrorCallback(virtualDevice, list, exception);
            }
        }

        private void invokeErrorCallback(VirtualDeviceImpl virtualDevice, List<Message> messages, Exception exception) {
            VirtualDeviceBase.NamedValueImpl values = null;
            for (Message message : messages) {
                List<DataItem<?>> dataItems = null;
                if (message instanceof DataMessage) {
                    DataMessage dataMessage = (DataMessage)message;
                    dataItems = dataMessage.getDataItems();
                }
                if (dataItems == null) continue;
                VirtualDeviceBase.NamedValueImpl last = null;
                for (DataItem<?> dataItem : dataItems) {
                    VirtualDeviceBase.NamedValueImpl namedValue = new VirtualDeviceBase.NamedValueImpl(dataItem.getKey(), dataItem.getValue());
                    if (virtualDevice.attributeMap.containsKey(dataItem.getKey())) {
                        try {
                            VirtualDeviceAttributeBase<VirtualDevice, Object> attribute = virtualDevice.getAttribute(dataItem.getKey());
                            if (attribute.getOnError() != null) {
                                attribute.getOnError().onError(new VirtualDeviceBase.ErrorEvent<VirtualDeviceImpl>(virtualDevice, namedValue, exception.getMessage()));
                            }
                        }
                        catch (IllegalArgumentException e) {
                            VirtualDeviceImpl.getLogger().log(Level.FINE, e.getMessage(), e);
                        }
                        catch (Exception e) {
                            VirtualDeviceImpl.getLogger().log(Level.FINE, e.getMessage(), e);
                        }
                    }
                    if (last != null) {
                        last.setNext(namedValue);
                        last = namedValue;
                        continue;
                    }
                    values = last = namedValue;
                }
            }
            if (virtualDevice.getErrorCallback() != null) {
                try {
                    VirtualDeviceBase.ErrorEvent<VirtualDeviceImpl> errorEvent = new VirtualDeviceBase.ErrorEvent<VirtualDeviceImpl>(virtualDevice, values, exception.getMessage());
                    virtualDevice.getErrorCallback().onError(errorEvent);
                }
                catch (Exception e) {
                    VirtualDeviceImpl.getLogger().log(Level.FINE, e.getMessage(), e);
                }
            }
        }
    }
}

