/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.iot.client.impl.device;

import com.oracle.iot.client.DeviceModelAttribute;
import com.oracle.iot.client.impl.VirtualDeviceAttributeBase;
import com.oracle.iot.client.impl.device.VirtualDeviceImpl;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.iot.client.device.VirtualDevice;

public final class VirtualDeviceAttributeImpl<T>
extends VirtualDeviceAttributeBase<VirtualDevice, T> {
    private static final Logger LOGGER = Logger.getLogger("oracle.iot.client");

    public VirtualDeviceAttributeImpl(VirtualDeviceImpl device, DeviceModelAttribute model) {
        super(device, model);
    }

    @Override
    public DeviceModelAttribute getDeviceModelAttribute() {
        return this.model;
    }

    @Override
    public void set(T value) {
        this.validate(this.model, value);
        if (VirtualDeviceAttributeImpl.getLogger().isLoggable(Level.FINER)) {
            VirtualDeviceAttributeImpl.getLogger().log(Level.FINER, "\nVirtualDevice: " + ((VirtualDevice)this.virtualDevice).toString() + "\n\t attributeName " + this.getDeviceModelAttribute().getName() + "\n\t attributeValue " + this.value + "\n\t newValue " + value + "\n");
        }
        this.lastKnownValue = this.value = value;
        ((VirtualDeviceImpl)this.virtualDevice).processOnChange(this, this.value);
    }

    @Override
    public boolean update(Object value) {
        this.validate(this.model, value);
        if (VirtualDeviceAttributeImpl.getLogger().isLoggable(Level.FINER)) {
            VirtualDeviceAttributeImpl.getLogger().log(Level.FINER, "\nVirtualDevice: " + ((VirtualDevice)this.virtualDevice).toString() + "\n\t attributeName " + this.getDeviceModelAttribute().getName() + "\n\t attributeValue " + this.value + "\n\t newValue " + value + "\n");
        }
        this.lastKnownValue = this.value = value;
        return true;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (obj.getClass() != this.getClass()) {
            return false;
        }
        VirtualDeviceAttributeImpl other = (VirtualDeviceAttributeImpl)obj;
        if (this.value != null ? !this.value.equals(other.value) : other.value != null) {
            return false;
        }
        return this.getDeviceModelAttribute().equals(((VirtualDeviceAttributeImpl)obj).getDeviceModelAttribute());
    }

    public int hashCode() {
        int hash = 37;
        hash = 37 * hash + (this.value != null ? this.value.hashCode() : 0);
        hash = 37 * this.getDeviceModelAttribute().hashCode();
        return hash;
    }

    @Override
    public boolean isSettable() {
        return true;
    }

    private static Logger getLogger() {
        return LOGGER;
    }
}

