/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.iot.client.impl.device;

import com.oracle.iot.client.device.util.StorageDispatcher;
import com.oracle.iot.client.impl.StorageConnection;
import java.io.InputStream;
import java.io.OutputStream;

final class StorageObjectDelegate
extends com.oracle.iot.client.impl.StorageObjectDelegate {
    private static final long PROGRESS_UPDATE_INTERVAL = 0x100000L;
    private volatile StorageDispatcher.Progress.State state = null;

    StorageObjectDelegate(StorageConnection storageConnection, String uri, String name, String contentType, String contentEncoding, String dateOfLastModification, long length) {
        super(storageConnection, uri, name, contentType, contentEncoding, dateOfLastModification, length);
    }

    void setState(StorageDispatcher.Progress.State state) {
        this.state = state;
    }

    StorageDispatcher.Progress.State getState() {
        return this.state;
    }

    @Override
    public void setTransferredBytes(long transferredBytes) {
        long diff = transferredBytes - this.transferredBytes;
        super.setTransferredBytes(transferredBytes);
        if (diff >= 0x100000L) {
            // empty if block
        }
    }

    @Override
    public void setOutputStream(OutputStream outputStream) {
        if (outputStream != null && this.state != null && this.state != StorageDispatcher.Progress.State.COMPLETED && this.state != StorageDispatcher.Progress.State.CANCELLED && this.state != StorageDispatcher.Progress.State.FAILED) {
            throw new IllegalStateException("sync in progress");
        }
        super.setOutputStream(outputStream);
        this.setState(null);
    }

    @Override
    public void setInputStream(InputStream inputStream) {
        if (inputStream != null && this.state != null && this.state != StorageDispatcher.Progress.State.COMPLETED && this.state != StorageDispatcher.Progress.State.CANCELLED && this.state != StorageDispatcher.Progress.State.FAILED) {
            throw new IllegalStateException("sync in progress");
        }
        super.setInputStream(inputStream);
        this.setState(null);
    }

    @Override
    public boolean isCancelled() {
        return this.state == StorageDispatcher.Progress.State.CANCELLED;
    }
}

