/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.iot.client.impl.device;

import com.oracle.iot.client.message.Message;

public class MessageRetryHandler {
    private final Message message;
    private final int allowedRetryCount;
    private int retryCount;

    MessageRetryHandler(Message message, int baseRetryCount) {
        if (message == null) {
            throw new NullPointerException();
        }
        this.message = message;
        this.retryCount = 0;
        switch (message.getReliability()) {
            case NO_GUARANTEE: {
                this.allowedRetryCount = baseRetryCount;
                break;
            }
            case BEST_EFFORT: {
                this.allowedRetryCount = baseRetryCount * 2;
                break;
            }
            case GUARANTEED_DELIVERY: {
                this.allowedRetryCount = Integer.MAX_VALUE;
                break;
            }
            default: {
                this.allowedRetryCount = 0;
            }
        }
    }

    Message getMessage() {
        return this.message;
    }

    void addRetry() {
        ++this.retryCount;
    }

    int getAvailableRetryCount() {
        return this.allowedRetryCount - this.retryCount;
    }

    int getRetryCount() {
        return this.retryCount;
    }
}

