/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.iot.client.impl.device;

import com.oracle.iot.client.impl.util.Base64;
import java.util.Arrays;
import java.util.Date;
import org.json.JSONException;
import org.json.JSONObject;

public class DirectActivationResponse {
    private static final String FIELD_ENDPOINT_ID = "endpointId";
    private static final String FIELD_ACTIVATION_TIME = "activationTime";
    private static final String FIELD_ENDPOINT_STATE = "endpointState";
    private static final String FIELD_CERTIFICATE = "certificate";
    private String endpointId;
    private Date activationTime;
    private String endpointState;
    private byte[] certificate;

    public byte[] getCertificate() {
        return this.certificate;
    }

    public void setCertificate(byte[] certificate) {
        this.certificate = certificate;
    }

    public Date getActivationTime() {
        return this.activationTime;
    }

    public void setActivationTime(Date activationTime) {
        this.activationTime = activationTime;
    }

    public String getEndpointState() {
        return this.endpointState;
    }

    public void setEndpointState(String endpointState) {
        this.endpointState = endpointState;
    }

    public String getEndpointId() {
        return this.endpointId;
    }

    public void setEndpointId(String endpointId) {
        this.endpointId = endpointId;
    }

    public String toString() {
        return "ActivationResponse{endpointId='" + this.endpointId + '\'' + ", activationTime=" + this.activationTime + ", endpointState='" + this.endpointState + '\'' + ", certificate=" + Arrays.toString(this.certificate) + '}';
    }

    public static DirectActivationResponse fromJson(JSONObject jsonObject) {
        DirectActivationResponse response = new DirectActivationResponse();
        try {
            response.endpointId = jsonObject.getString(FIELD_ENDPOINT_ID);
            response.endpointState = jsonObject.getString(FIELD_ENDPOINT_STATE);
        }
        catch (JSONException e) {
            throw new RuntimeException(e);
        }
        String fieldCertificate = jsonObject.optString(FIELD_CERTIFICATE, null);
        if (fieldCertificate != null) {
            String certificateString = fieldCertificate.toString().replace("\r", "").replace("\n", "");
            response.certificate = Base64.getDecoder().decode(certificateString);
        } else {
            response.certificate = new byte[0];
        }
        return response;
    }

    public String toJson() {
        JSONObject objectBuilder = new JSONObject();
        try {
            objectBuilder.put(FIELD_ENDPOINT_ID, (Object)this.endpointId);
            objectBuilder.put(FIELD_ENDPOINT_STATE, (Object)this.endpointState);
            objectBuilder.put(FIELD_ACTIVATION_TIME, (Object)this.activationTime.toString());
        }
        catch (JSONException e) {
            throw new RuntimeException(e);
        }
        return objectBuilder.toString();
    }
}

