/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.iot.client.impl;

import com.oracle.iot.client.DeviceModelAttribute;
import com.oracle.iot.client.DeviceModelFormat;
import java.util.List;

public class DeviceModelFormatImpl
extends DeviceModelFormat {
    private final String urn;
    private final String name;
    private final String description;
    private DeviceModelFormat.Type type;
    private final List<DeviceModelFormat.Field> fields;

    public DeviceModelFormatImpl(String urn, String name, String description, String type, List<DeviceModelFormat.Field> fields) {
        this.urn = urn;
        this.name = name;
        this.description = description;
        try {
            this.type = DeviceModelFormat.Type.valueOf(type);
        }
        catch (IllegalArgumentException e) {
            this.type = null;
        }
        this.fields = fields;
    }

    @Override
    public String getURN() {
        return this.urn;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public DeviceModelFormat.Type getType() {
        return this.type;
    }

    @Override
    public List<DeviceModelFormat.Field> getFields() {
        return this.fields;
    }

    public String toString() {
        StringBuilder b = new StringBuilder("name = ");
        b.append(this.name);
        b.append(", description = ");
        b.append(this.description);
        b.append(", type = ");
        b.append((Object)this.type);
        b.append(",\n fields = [");
        boolean firstItem = true;
        for (DeviceModelFormat.Field field : this.fields) {
            if (!firstItem) {
                b.append(",");
            } else {
                firstItem = false;
            }
            b.append("\n {");
            b.append(field);
            b.append("}");
        }
        if (!firstItem) {
            b.append("\n");
        }
        b.append(" ]");
        return b.toString();
    }

    static class FieldImpl
    implements DeviceModelFormat.Field {
        private final String name;
        private final String description;
        private final DeviceModelAttribute.Type type;
        private final boolean optional;

        FieldImpl(String name, String description, String type, boolean optional) {
            this.name = name;
            this.description = description;
            this.type = DeviceModelAttribute.Type.valueOf(type);
            this.optional = optional;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public DeviceModelAttribute.Type getType() {
            return this.type;
        }

        @Override
        public boolean isOptional() {
            return this.optional;
        }

        public String toString() {
            StringBuilder b = new StringBuilder("name = ");
            b.append(this.name);
            b.append(", description = ");
            b.append(this.description);
            b.append(", type = ");
            b.append((Object)this.type);
            b.append(", optional = ");
            b.append(this.optional);
            return b.toString();
        }
    }
}

