/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.iot.client.device.util;

import com.oracle.iot.client.device.DirectlyConnectedDevice;
import com.oracle.iot.client.device.util.RequestDispatcher;
import com.oracle.iot.client.impl.device.MessageDispatcherImpl;
import com.oracle.iot.client.message.Message;
import java.io.Closeable;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;

public abstract class MessageDispatcher
implements Closeable {
    private static final Map<DirectlyConnectedDevice, MessageDispatcher> dispatcherMap = new WeakHashMap<DirectlyConnectedDevice, MessageDispatcher>();

    public static MessageDispatcher getMessageDispatcher(DirectlyConnectedDevice directlyConnectedDevice) {
        MessageDispatcherImpl messageDispatcher = (MessageDispatcherImpl)dispatcherMap.get(directlyConnectedDevice);
        if (messageDispatcher == null || messageDispatcher.isClosed()) {
            messageDispatcher = new MessageDispatcherImpl(directlyConnectedDevice);
            dispatcherMap.put(directlyConnectedDevice, messageDispatcher);
        }
        return messageDispatcher;
    }

    static MessageDispatcher remove(DirectlyConnectedDevice directlyConnectedDevice) {
        return dispatcherMap.remove(directlyConnectedDevice);
    }

    public abstract RequestDispatcher getRequestDispatcher();

    public abstract void queue(Message var1);

    public abstract void setOnError(ErrorCallback var1);

    public abstract void setOnDelivery(DeliveryCallback var1);

    public static interface ErrorCallback {
        public void failed(List<Message> var1, Exception var2);
    }

    public static interface DeliveryCallback {
        public void delivered(List<Message> var1);
    }
}

