/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.iot.client;

import com.oracle.iot.client.HttpResponse;
import com.oracle.iot.client.trust.TrustedAssetsManager;
import java.io.Closeable;
import java.io.IOException;
import java.security.GeneralSecurityException;

public abstract class SecureConnection
implements Closeable {
    protected final TrustedAssetsManager trustedAssetsManager;
    protected final boolean useOnlySharedSecret;
    private boolean closed = false;

    protected SecureConnection(TrustedAssetsManager trustedAssetsManager, boolean useOnlySharedSecret) {
        this.trustedAssetsManager = trustedAssetsManager;
        this.useOnlySharedSecret = useOnlySharedSecret;
    }

    public final String getEndpointId() {
        try {
            return this.trustedAssetsManager.getEndpointId();
        }
        catch (IllegalStateException e) {
            if (this.trustedAssetsManager.getClientId() == null) {
                return null;
            }
            throw e;
        }
    }

    public abstract HttpResponse get(String var1) throws IOException, GeneralSecurityException;

    public abstract HttpResponse post(String var1, byte[] var2) throws IOException, GeneralSecurityException;

    public abstract HttpResponse post(String var1, byte[] var2, int var3) throws IOException, GeneralSecurityException;

    public abstract HttpResponse put(String var1, byte[] var2) throws IOException, GeneralSecurityException;

    public abstract HttpResponse delete(String var1) throws IOException, GeneralSecurityException;

    public abstract HttpResponse patch(String var1, byte[] var2) throws IOException, GeneralSecurityException;

    @Override
    public void close() throws IOException {
        this.closed = true;
        this.disconnect();
        this.trustedAssetsManager.close();
    }

    public boolean isClosed() {
        return this.closed;
    }

    public void disconnect() {
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        SecureConnection other = (SecureConnection)obj;
        if (this.useOnlySharedSecret ^ other.useOnlySharedSecret) {
            return false;
        }
        if (this.trustedAssetsManager.isActivated() ^ other.trustedAssetsManager.isActivated()) {
            return false;
        }
        if (!this.trustedAssetsManager.getServerHost().equals(other.trustedAssetsManager.getServerHost())) {
            return false;
        }
        if (this.trustedAssetsManager.getServerPort() != other.trustedAssetsManager.getServerPort()) {
            return false;
        }
        if (!this.trustedAssetsManager.isActivated()) {
            return this.trustedAssetsManager.getClientId().equals(other.trustedAssetsManager.getClientId());
        }
        if (!this.trustedAssetsManager.getEndpointId().equals(other.trustedAssetsManager.getEndpointId())) {
            return false;
        }
        if (this.trustedAssetsManager.getPublicKey() == null) {
            return other.trustedAssetsManager.getPublicKey() == null;
        }
        return this.trustedAssetsManager.getPublicKey().equals(other.trustedAssetsManager.getPublicKey());
    }

    public int hashCode() {
        int hash = 37;
        hash = 37 * hash + (this.useOnlySharedSecret ? 1 : 0);
        hash = 37 * hash + (this.trustedAssetsManager.isActivated() ? this.trustedAssetsManager.getEndpointId().hashCode() : this.trustedAssetsManager.getClientId().hashCode()) + this.trustedAssetsManager.getServerHost().hashCode() + this.trustedAssetsManager.getServerPort();
        return hash;
    }

    protected final TrustedAssetsManager getTrustedAssetsManager() {
        return this.trustedAssetsManager;
    }

    protected final boolean usesOnlySharedSecret() {
        return this.useOnlySharedSecret;
    }
}

