/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.iot.client.impl.trust;

import com.oracle.iot.client.impl.trust.DefaultTrustedAssetsManager;
import com.oracle.iot.client.impl.trust.UnifiedTrustedAssetsManager;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.ConnectException;
import java.net.Socket;
import java.net.UnknownHostException;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.PublicKey;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Scanner;
import java.util.Vector;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;

public class DefaultTrustedAssetsProvisionerBase {
    private static final int DEFAULT_HTTPS_PORT = 443;
    private static final String MQTTS_SCHEME = "mqtts";
    private static final String HTTPS_SCHEME = "https";
    private static final int DEFAULT_MQTTS_PORT = 8883;
    protected static String INTEGRATION_ID_PROMPT = "Enter the ID";
    protected static String INTEGRATION_SECRET_PROMPT = "Enter the Shared Secret";
    protected static String ACTIVATION_ID_PROMPT = "Enter the Activation ID";
    protected static String ACTIVATION_SECRET_PROMPT = "Enter the Activation Secret";
    private static final String lineSep = System.getProperty("line.separator", "\n");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void main(String[] args, String taPath, String storeExtension, boolean hideUserAuthSupport) {
        String arg;
        boolean isEnterpriseClient = false;
        boolean listTa = false;
        boolean verbose = false;
        boolean userAuth = false;
        String idPrompt = ACTIVATION_ID_PROMPT;
        String secretPrompt = ACTIVATION_SECRET_PROMPT;
        int index = 0;
        while ((arg = DefaultTrustedAssetsProvisionerBase.nextArg(args, index++)) != null) {
            if (arg.equals("-e")) {
                isEnterpriseClient = true;
                idPrompt = INTEGRATION_ID_PROMPT;
                secretPrompt = INTEGRATION_SECRET_PROMPT;
                continue;
            }
            if (!hideUserAuthSupport && arg.equals("-u")) {
                isEnterpriseClient = true;
                userAuth = true;
                idPrompt = INTEGRATION_ID_PROMPT;
                continue;
            }
            if (arg.equals("-h")) {
                DefaultTrustedAssetsProvisionerBase.showUsage(hideUserAuthSupport);
                System.exit(0);
            }
            if (arg.equals("-l")) {
                listTa = true;
                continue;
            }
            if (!arg.equals("-v")) break;
            listTa = true;
            verbose = true;
        }
        try {
            String icd;
            HashMap<String, SecretKey> icdMap;
            String taPassword;
            String sharedSecret;
            String taStore;
            File taFile;
            int serverPort;
            String serverScheme;
            if (arg != null) {
                File file = new File(arg);
                if (file.exists()) {
                    if (listTa) {
                        String password;
                        if ((password = DefaultTrustedAssetsProvisionerBase.nextArg(args, index++)) == null) {
                            password = DefaultTrustedAssetsProvisionerBase.promptForInput("Enter passphrase");
                        }
                        DefaultTrustedAssetsProvisionerBase.listStore(file, password, verbose);
                        System.exit(0);
                    }
                    DefaultTrustedAssetsProvisionerBase.argError("Incorrect argument: " + arg);
                }
            } else {
                arg = DefaultTrustedAssetsProvisionerBase.promptForInput("Enter Cloud Service URI");
            }
            HttpUrl url = new HttpUrl(arg);
            String serverHost = url.host;
            if (serverHost == null) {
                url = new HttpUrl(HTTPS_SCHEME, "//" + arg);
                serverHost = url.host;
                if (serverHost == null) {
                    DefaultTrustedAssetsProvisionerBase.argError("Argument not a URI: " + arg);
                }
            }
            if (!MQTTS_SCHEME.equals(serverScheme = url.getScheme()) && !HTTPS_SCHEME.equals(serverScheme)) {
                DefaultTrustedAssetsProvisionerBase.argError("Unsupported scheme: " + serverScheme);
            }
            if ((serverPort = url.port) == -1) {
                serverPort = MQTTS_SCHEME.equals(serverScheme) ? 8883 : 443;
            }
            X509Certificate serverRootCert = null;
            Map<String, String> env = System.getenv();
            String envCert = env.get("SERVER_ROOT_CERTIFICATE");
            if (envCert != null && !envCert.isEmpty()) {
                File file = new File(envCert);
                if (!file.exists()) {
                    DefaultTrustedAssetsProvisionerBase.argError("Cannot find server root certificate: " + envCert);
                }
                try {
                    serverRootCert = DefaultTrustedAssetsProvisionerBase.certFromPem(file);
                }
                catch (Exception e) {
                    DefaultTrustedAssetsProvisionerBase.argError("Cannot create certificate from file " + envCert);
                }
                if (!DefaultTrustedAssetsProvisionerBase.checkConnectivity(serverRootCert, serverHost, serverPort)) {
                    DefaultTrustedAssetsProvisionerBase.display("\nWarning could not connect to " + serverHost + ":" + serverPort + " with SERVER_ROOT_CERTIFICATE " + envCert + ". Creating trusted assets store anyway.");
                }
            } else {
                try {
                    serverRootCert = DefaultTrustedAssetsProvisionerBase.caCertFromServer(serverHost, serverPort);
                }
                catch (UnknownHostException uhe) {
                    DefaultTrustedAssetsProvisionerBase.argError("Unknown host " + serverHost);
                }
                catch (ConnectException ce) {
                    DefaultTrustedAssetsProvisionerBase.argError(serverHost + " refused HTTPS connection at port " + serverPort);
                }
            }
            String clientId = DefaultTrustedAssetsProvisionerBase.nextArg(args, index++);
            if (clientId == null) {
                clientId = DefaultTrustedAssetsProvisionerBase.promptForInput(idPrompt);
            }
            if ((taFile = new File(taStore = taPath + clientId + "." + storeExtension)).exists()) {
                DefaultTrustedAssetsProvisionerBase.argError(taStore + " already exists");
            }
            if ((sharedSecret = DefaultTrustedAssetsProvisionerBase.nextArg(args, index++)) == null && !userAuth) {
                sharedSecret = DefaultTrustedAssetsProvisionerBase.promptForInput(secretPrompt);
            }
            if ((taPassword = DefaultTrustedAssetsProvisionerBase.nextArg(args, index++)) == null) {
                taPassword = DefaultTrustedAssetsProvisionerBase.promptForInput("Enter passphrase");
            }
            HashMap<String, SecretKey> hashMap = icdMap = (icd = DefaultTrustedAssetsProvisionerBase.nextArg(args, index++)) != null ? new HashMap<String, SecretKey>() : null;
            while (icd != null) {
                String icdSecret;
                if ((icdSecret = DefaultTrustedAssetsProvisionerBase.nextArg(args, index++)) == null) {
                    DefaultTrustedAssetsProvisionerBase.argError("Incorrect connected device format. Missing shared secret for: " + icd);
                }
                byte[] secretBytes = icdSecret.getBytes("UTF-8");
                SecretKeySpec secretKey = new SecretKeySpec(secretBytes, "Hmac");
                icdMap.put(icd, secretKey);
                icd = DefaultTrustedAssetsProvisionerBase.nextArg(args, index++);
            }
            byte[] tas = UnifiedTrustedAssetsManager.createTas(taPassword, serverScheme, serverHost, serverPort, clientId, sharedSecret, isEnterpriseClient ? clientId : null, serverRootCert, null, null, icdMap);
            FileOutputStream fos = new FileOutputStream(taFile);
            try {
                fos.write(tas);
                fos.flush();
            }
            finally {
                try {
                    fos.close();
                }
                catch (IOException ioe) {}
            }
            if (listTa) {
                DefaultTrustedAssetsProvisionerBase.listStore(taFile, taPassword, verbose);
            } else {
                DefaultTrustedAssetsProvisionerBase.display("\nCreated trusted assets store: " + taStore + "\n");
            }
        }
        catch (IllegalArgumentException iae) {
            DefaultTrustedAssetsProvisionerBase.displayError(iae.getMessage());
            System.exit(1);
        }
        catch (Exception e) {
            DefaultTrustedAssetsProvisionerBase.displayError(e.getMessage());
            System.exit(2);
        }
    }

    private static X509Certificate caCertFromServer(String host, int port) throws Exception {
        X509Certificate[] chain = DefaultTrustedAssetsProvisionerBase.getCertChain(host, port);
        if (chain.length == 0) {
            throw new Exception("No certificates from the SSL server");
        }
        X509Certificate caCert = chain[chain.length - 1];
        if (caCert.getSubjectX500Principal().equals(caCert.getIssuerX500Principal())) {
            return caCert;
        }
        try (Socket socket = null;){
            socket = (SSLSocket)SSLContext.getDefault().getSocketFactory().createSocket(host, port);
            ((SSLSocket)socket).startHandshake();
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static X509Certificate[] getCertChain(String host, int port) throws Exception {
        SSLSocketFactory socketFactory;
        GetChainTrustManager trustManager = new GetChainTrustManager();
        try {
            SSLContext context = SSLContext.getInstance("TLS");
            context.init(null, new TrustManager[]{trustManager}, null);
            socketFactory = context.getSocketFactory();
        }
        catch (GeneralSecurityException gse) {
            throw new IOException("No initialized SSLSocketFactory");
        }
        SSLSocket socket = null;
        GetChainTrustManager getChainTrustManager = trustManager;
        synchronized (getChainTrustManager) {
            try {
                socket = (SSLSocket)socketFactory.createSocket(host, port);
                socket.startHandshake();
                X509Certificate[] x509CertificateArray = trustManager.serverChain;
                return x509CertificateArray;
            }
            catch (IOException ioe) {
                if (trustManager.exchangedServerCerts && trustManager.serverChain != null) {
                    X509Certificate[] x509CertificateArray2 = trustManager.serverChain;
                    return x509CertificateArray2;
                }
                throw ioe;
            }
            finally {
                if (socket != null) {
                    socket.close();
                }
                trustManager.cleanup();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static X509Certificate certFromPem(File file) throws Exception {
        try (FileInputStream fis = new FileInputStream(file);){
            CertificateFactory cf = CertificateFactory.getInstance("X.509");
            X509Certificate x509Certificate = (X509Certificate)cf.generateCertificate(fis);
            return x509Certificate;
        }
    }

    private static void provision(File file, String taPassword, String serverScheme, String serverHost, int serverPort, String clientId, String sharedSecret, boolean isEnterpriseClient, X509Certificate trustAnchor, boolean userAuth) throws Exception {
        DefaultTrustedAssetsManager.ProvisioningSupport provisioningSupport = DefaultTrustedAssetsManager.ProvisioningSupport.create(file, taPassword);
        provisioningSupport.setServer(serverScheme, serverHost, serverPort);
        if (isEnterpriseClient) {
            if (!userAuth) {
                provisioningSupport.setEnterpriseClientCredentials(clientId, sharedSecret);
            }
        } else {
            provisioningSupport.setClientCredentials(clientId, sharedSecret);
        }
        if (trustAnchor != null) {
            provisioningSupport.addTrustAnchor("trustAnchor", trustAnchor);
        }
        provisioningSupport.provision();
    }

    private static void listStore(File file, String taPassword, boolean verbose) throws Exception {
        UnifiedTrustedAssetsManager tam = new UnifiedTrustedAssetsManager(file.getPath(), taPassword, null);
        DefaultTrustedAssetsProvisionerBase.display("\nTrusted assets store: " + file);
        try {
            String host = tam.getServerHost();
            int port = tam.getServerPort();
            String scheme = tam.getServerScheme();
            DefaultTrustedAssetsProvisionerBase.display(" Server URI: " + scheme + "://" + host + ":" + port);
        }
        catch (IllegalStateException ise) {
            DefaultTrustedAssetsProvisionerBase.display(" Server URI is not set.");
        }
        PublicKey key = null;
        try {
            key = tam.getPublicKey();
        }
        catch (IllegalStateException ise) {
            // empty catch block
        }
        try {
            String clientId = tam.getClientId();
            Object endpointId = null;
            try {
                endpointId = tam.getEndpointId();
            }
            catch (IllegalStateException ise) {
                // empty catch block
            }
            if (clientId.equals(endpointId) && key == null) {
                DefaultTrustedAssetsProvisionerBase.display(" Enterprise integration ID: " + clientId);
            } else {
                DefaultTrustedAssetsProvisionerBase.display(" Activation ID: " + clientId);
                if (endpointId != null) {
                    DefaultTrustedAssetsProvisionerBase.display(" Device ID: " + (String)endpointId);
                }
            }
        }
        catch (IllegalStateException ise) {
            DefaultTrustedAssetsProvisionerBase.display(" Device ID is not set.");
        }
        if (tam.icdMap != null) {
            StringBuilder builder = new StringBuilder(" Connected Devices: [");
            for (String icd : tam.icdMap.keySet()) {
                builder.append(icd).append(", ");
            }
            int len = builder.length();
            builder.replace(len - 2, len, "]");
            DefaultTrustedAssetsProvisionerBase.display(builder.toString());
        }
        if (!verbose) {
            return;
        }
        if (key == null) {
            DefaultTrustedAssetsProvisionerBase.display(" Public key pair is not set.");
        } else {
            DefaultTrustedAssetsProvisionerBase.display(" Public key pair is set.");
        }
        Vector<byte[]> certs = tam.getTrustAnchorCertificates();
        if (certs.size() == 0) {
            DefaultTrustedAssetsProvisionerBase.display(" Trust anchor certificates are not set.");
        } else {
            DefaultTrustedAssetsProvisionerBase.display(" Trust anchor certificates are set.");
            if (verbose) {
                StringBuilder sb = new StringBuilder(lineSep);
                try {
                    CertificateFactory factory = CertificateFactory.getInstance("X.509");
                    for (byte[] cert : certs) {
                        ByteArrayInputStream inputStream = new ByteArrayInputStream(cert);
                        Certificate certificate = factory.generateCertificate(inputStream);
                        sb.append(certificate.toString()).append(lineSep);
                    }
                }
                catch (CertificateException e) {
                    sb.delete(0, sb.length());
                    for (byte[] cert : certs) {
                        sb.append(lineSep);
                        for (byte b : cert) {
                            sb.append(String.format(Locale.ROOT, "%02x", b & 0xFF));
                        }
                    }
                }
                DefaultTrustedAssetsProvisionerBase.display(sb.toString());
            }
        }
    }

    private static String nextArg(String[] args, int index) {
        if (index >= args.length) {
            return null;
        }
        return args[index].trim();
    }

    private static void argError(String msg) {
        throw new IllegalArgumentException(msg);
    }

    private static String promptForInput(String prompt) {
        Scanner scanner = new Scanner(System.in);
        System.out.print(prompt + ": ");
        return scanner.next().trim();
    }

    private static void showUsage(boolean hideUserAuthSupport) {
        DefaultTrustedAssetsProvisionerBase.display(" [option...] <URI> <ID> <Secret> <password> [<ID> <sharedSecret>]\n                             or\n                   -l <provisioned file> <password>\noptions:\n    -e : to indicate <ID> is an Enterprise Integration ID");
        if (!hideUserAuthSupport) {
            DefaultTrustedAssetsProvisionerBase.display("    -u : to indicate <ID> is an Enterprise Integration ID used for User Authentication");
        }
        DefaultTrustedAssetsProvisionerBase.display("    -h : help\n    -l : to list the URI and IDs in the provisioned file\n    -v : to list all of the contents of the provisioned file\n<URI> is entered as [<scheme>://]<host>[:<port>]\n\twhere <scheme> is one of \"mqtts\" or \"https\"\n<ID> is either an Activation ID or Enterprise Integration ID\n<Secret> is either the Activation Secret from registering the\n\tdevice on the server or the Shared Secret from creating\n\tthe enterprise integration\n<password> is a passphrase used to protect the integrity of the\n\ttrusted assets store\n<ID> <sharedSecret> provisions an indirectly connected device.\n\t<ID> is the Activation ID of an indirectly connected device, and <sharedSecret>\n\tis the shared secret entered when registering the indirectly connected device.\n\tThe <ID> is separated from the <sharedSecret> by a space and there may be\n\tzero or more <ID> <sharedSecret> pairs.\n\nIn addition, the automatic trust anchor processing may be overridden\nby setting the environment variable SERVER_ROOT_CERTIFICATE to a\nfile containing a PEM/PKCS7 encoded certificate.");
    }

    private static void display(String s) {
        System.out.println(s);
    }

    private static void displayError(String s) {
        System.err.println("\n" + s + "\n");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean checkConnectivity(X509Certificate cert, String host, int port) {
        Socket socket = null;
        FileInputStream fis = null;
        try {
            String alias = "alias";
            KeyStore trustStore = KeyStore.getInstance(KeyStore.getDefaultType());
            trustStore.load(null);
            trustStore.setCertificateEntry(alias, cert);
            KeyManagerFactory kmf = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
            kmf.init(trustStore, null);
            KeyManager[] keyManagers = kmf.getKeyManagers();
            TrustManagerFactory tmf = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
            tmf.init(trustStore);
            TrustManager[] trustManagers = tmf.getTrustManagers();
            SSLContext sslContext = SSLContext.getInstance("TLS");
            sslContext.init(keyManagers, trustManagers, null);
            socket = (SSLSocket)sslContext.getSocketFactory().createSocket(host, port);
            ((SSLSocket)socket).startHandshake();
        }
        catch (IOException e) {
            boolean bl = false;
            return bl;
        }
        catch (Exception e) {
            DefaultTrustedAssetsProvisionerBase.displayError(e.getMessage());
            System.exit(2);
        }
        finally {
            try {
                if (socket != null) {
                    socket.close();
                }
                if (fis != null) {
                    fis.close();
                }
            }
            catch (Exception e) {}
        }
        return true;
    }

    private static class HttpUrl {
        public String scheme;
        public String authority;
        public String path;
        public String query;
        public String fragment;
        public String host;
        public int port = -1;

        public HttpUrl(String url) {
            int afterScheme = 0;
            if (url == null) {
                return;
            }
            int length = url.length();
            if (length == 0) {
                return;
            }
            int endOfScheme = url.indexOf(58);
            if (endOfScheme != -1) {
                if (endOfScheme == length - 1) {
                    this.scheme = url.substring(0, endOfScheme);
                    return;
                }
                if (endOfScheme < length - 2 && url.charAt(endOfScheme + 1) == '/' && url.charAt(endOfScheme + 2) == '/') {
                    this.scheme = url.substring(0, endOfScheme);
                    afterScheme = endOfScheme + 1;
                }
            }
            this.parseAfterScheme(url, afterScheme, length);
        }

        public HttpUrl(String theScheme, String partialUrl) {
            this.scheme = theScheme;
            if (partialUrl == null) {
                return;
            }
            int length = partialUrl.length();
            if (length == 0) {
                return;
            }
            this.parseAfterScheme(partialUrl, 0, length);
        }

        public String getScheme() {
            return this.scheme;
        }

        private void parseAfterScheme(String url, int afterScheme, int length) {
            int endOfHost;
            int posSqBr;
            int endOfUrl;
            if (url.indexOf(32) != -1 || url.indexOf(13) != -1 || url.indexOf(10) != -1 || url.indexOf(7) != -1) {
                throw new IllegalArgumentException("Space character in URL");
            }
            int endOfAuthority = endOfUrl = length;
            int endOfPath = endOfUrl;
            int endOfQuery = endOfUrl;
            int startOfAuthority = url.startsWith("//", afterScheme) ? afterScheme + 2 : afterScheme;
            int start = url.indexOf(35, startOfAuthority);
            if (start != -1) {
                endOfAuthority = start;
                endOfPath = start;
                endOfQuery = start++;
                if (start < endOfUrl) {
                    this.fragment = url.substring(start, endOfUrl);
                }
            }
            if ((start = url.indexOf(63, startOfAuthority)) != -1 && start < endOfQuery) {
                endOfAuthority = start;
                endOfPath = start++;
                if (start < endOfQuery) {
                    this.query = url.substring(start, endOfQuery);
                }
            }
            if ((start = startOfAuthority == afterScheme ? afterScheme : ((posSqBr = url.indexOf(93, startOfAuthority)) > -1 ? url.indexOf(47, posSqBr) : url.indexOf(47, startOfAuthority))) != -1 && start < endOfPath) {
                endOfAuthority = start;
                this.path = url.substring(start, endOfPath);
            }
            if (startOfAuthority >= endOfAuthority) {
                return;
            }
            this.authority = url.substring(startOfAuthority, endOfAuthority);
            int endOfPort = this.authority.length();
            start = this.authority.indexOf(93);
            int startOfPort = start == -1 ? this.authority.indexOf(58) : this.authority.indexOf(58, start);
            if (startOfPort != -1) {
                endOfHost = startOfPort++;
                if (startOfPort < endOfPort) {
                    try {
                        this.port = Integer.parseInt(this.authority.substring(startOfPort, endOfPort));
                        if (this.port < 0) {
                            throw new IllegalArgumentException("invalid port format");
                        }
                        if (this.port == 0 || this.port > 65535) {
                            throw new IllegalArgumentException("port out of legal range");
                        }
                    }
                    catch (NumberFormatException nfe) {
                        throw new IllegalArgumentException("invalid port format");
                    }
                }
            } else {
                endOfHost = endOfPort;
            }
            if (endOfHost < 1) {
                return;
            }
            this.host = this.authority.substring(0, endOfHost);
            int hostLength = this.host.length();
            if (this.host.lastIndexOf(46) == hostLength - 1 || this.host.lastIndexOf(45) == hostLength - 1) {
                throw new IllegalArgumentException("invalid host format");
            }
            if (this.host.charAt(0) == '[') {
                if (!this.isValidIPv6Address(this.host)) {
                    throw new IllegalArgumentException("invalid IPv6 format");
                }
                return;
            }
            if (Character.isDigit(this.host.charAt(0))) {
                if (!this.isValidIPv4Address(this.host)) {
                    throw new IllegalArgumentException("invalid IPv4 format");
                }
                return;
            }
            if (!this.isValidHostName(this.host)) {
                throw new IllegalArgumentException("invalid host format");
            }
        }

        public void addBaseUrl(String baseUrl) {
            this.addBaseUrl(new HttpUrl(baseUrl));
        }

        public void addBaseUrl(HttpUrl baseUrl) {
            if (this.authority != null) {
                return;
            }
            this.scheme = baseUrl.scheme;
            this.authority = baseUrl.authority;
            if (this.path == null) {
                this.path = baseUrl.path;
                return;
            }
            if (this.path.charAt(0) == '/' || baseUrl.path == null || baseUrl.path.charAt(0) != '/') {
                return;
            }
            String basePath = baseUrl.path.substring(0, baseUrl.path.lastIndexOf(47));
            this.path = basePath + '/' + this.path;
        }

        public String toString() {
            StringBuffer url = new StringBuffer();
            if (this.scheme != null) {
                url.append(this.scheme);
                url.append(':');
            }
            if (this.authority != null || this.scheme != null) {
                url.append('/');
                url.append('/');
            }
            if (this.authority != null) {
                url.append(this.authority);
            }
            if (this.path != null) {
                url.append(this.path);
            }
            if (this.query != null) {
                url.append('?');
                url.append(this.query);
            }
            if (this.fragment != null) {
                url.append('#');
                url.append(this.fragment);
            }
            return url.toString();
        }

        private boolean isValidIPv6Address(String address) {
            int length;
            int addressLength = address.length();
            if (addressLength < 4) {
                return false;
            }
            if (address.charAt(0) != '[' || address.charAt(addressLength - 1) != ']') {
                return false;
            }
            String IPv6 = address.substring(1, addressLength - 1);
            int IPv6Length = addressLength - 2;
            int ptrChar = 0;
            int numHexPieces = 0;
            char currChar = '\u0000';
            String hexString = null;
            String separator = null;
            boolean isDoubleColon = false;
            boolean lastSeparator = true;
            while (ptrChar < IPv6Length) {
                currChar = IPv6.charAt(ptrChar);
                if (this.isHex(currChar)) {
                    hexString = this.getNextHexValue(IPv6, ptrChar, false);
                    length = hexString.length();
                    if (length > 4) {
                        return false;
                    }
                    ptrChar += length;
                    lastSeparator = false;
                    continue;
                }
                if (currChar == ':') {
                    if (++numHexPieces > 7) {
                        return false;
                    }
                    separator = this.getNextHexValue(IPv6, ptrChar, true);
                    length = separator.length();
                    if (separator.equals("::")) {
                        if (isDoubleColon) {
                            return false;
                        }
                        isDoubleColon = true;
                    } else {
                        if (length > 1) {
                            return false;
                        }
                        if (ptrChar == 0) {
                            return false;
                        }
                        if (isDoubleColon && numHexPieces > 6) {
                            return false;
                        }
                    }
                    ptrChar += length;
                    lastSeparator = true;
                    continue;
                }
                if (currChar == '.') {
                    if (hexString == null || !this.isDecimal(hexString)) {
                        return false;
                    }
                    if (!(!isDoubleColon && numHexPieces == 6 || isDoubleColon && numHexPieces < 6)) {
                        return false;
                    }
                    return this.isValidIPv4Address(IPv6.substring(ptrChar -= hexString.length()));
                }
                if (currChar == '/') break;
                return false;
            }
            if (lastSeparator && separator.equals(":")) {
                return false;
            }
            if (!(!isDoubleColon && numHexPieces == 7 || isDoubleColon && numHexPieces < 7)) {
                return false;
            }
            if (currChar == '/') {
                String decString;
                if ((length = (decString = this.getNextDecValue(IPv6, ++ptrChar, false)).length()) == 0 || ptrChar + length < IPv6Length) {
                    return false;
                }
                int i = Integer.parseInt(decString);
                if (i < 1 || i > 128) {
                    return false;
                }
            }
            return true;
        }

        private boolean isValidIPv4Address(String address) {
            if (address.length() < 7) {
                return false;
            }
            int IPv4Length = address.length();
            int ptrChar = 0;
            int numDecPieces = 0;
            boolean lastSeparator = true;
            while (ptrChar < IPv4Length) {
                char currChar = address.charAt(ptrChar);
                if (Character.isDigit(currChar)) {
                    String decString = this.getNextDecValue(address, ptrChar, false);
                    int value = Integer.parseInt(decString);
                    if (value < 0 || value > 255) {
                        return false;
                    }
                    ptrChar += decString.length();
                    lastSeparator = false;
                    continue;
                }
                if (currChar == '.') {
                    if (++numDecPieces > 3) {
                        return false;
                    }
                    String separator = this.getNextDecValue(address, ptrChar, true);
                    int length = separator.length();
                    if (length > 1) {
                        return false;
                    }
                    ptrChar += length;
                    lastSeparator = true;
                    continue;
                }
                return false;
            }
            return !lastSeparator && numDecPieces >= 3;
        }

        private boolean isValidHostName(String host) {
            int ptrChar = 0;
            int lenDomain = 0;
            while (ptrChar < host.length()) {
                char currChar;
                if ((currChar = host.charAt(ptrChar++)) == '.') {
                    if (lenDomain == 0) {
                        return false;
                    }
                    lenDomain = 0;
                    continue;
                }
                if (currChar == '-' || Character.isDigit(currChar)) {
                    if (lenDomain == 0) {
                        return false;
                    }
                    ++lenDomain;
                    continue;
                }
                if (Character.isLowerCase(currChar) || Character.isUpperCase(currChar)) {
                    ++lenDomain;
                    continue;
                }
                return false;
            }
            return true;
        }

        private boolean isHex(char sym) {
            return Character.isDigit(sym) || "ABCDEFabcdef".indexOf(sym) > -1;
        }

        private String getNextHexValue(String str, int offset, boolean isSeparator) {
            char sym;
            StringBuffer strOut = new StringBuffer();
            int length = str.length();
            int i = offset;
            while (i < length && (this.isHex(sym = str.charAt(i++)) || isSeparator) && (!this.isHex(sym) && sym != '/' || !isSeparator)) {
                strOut.append(sym);
            }
            return strOut.toString();
        }

        private String getNextDecValue(String str, int offset, boolean isSeparator) {
            char sym;
            StringBuffer strOut = new StringBuffer();
            int length = str.length();
            int i = offset;
            while (!(i >= length || !Character.isDigit(sym = str.charAt(i++)) && !isSeparator || Character.isDigit(sym) && isSeparator)) {
                strOut.append(sym);
            }
            return strOut.toString();
        }

        private boolean isDecimal(String str) {
            for (int i = 0; i < str.length(); ++i) {
                if (Character.isDigit(str.charAt(i))) continue;
                return false;
            }
            return true;
        }
    }

    private static class GetChainTrustManager
    implements X509TrustManager {
        private X509Certificate[] serverChain = new X509Certificate[0];
        private boolean exchangedServerCerts = false;

        private GetChainTrustManager() {
        }

        @Override
        public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
            throw new UnsupportedOperationException();
        }

        @Override
        public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
            this.exchangedServerCerts = true;
            if (chain != null) {
                this.serverChain = chain;
            }
        }

        @Override
        public X509Certificate[] getAcceptedIssuers() {
            return new X509Certificate[0];
        }

        void cleanup() {
            this.exchangedServerCerts = false;
            this.serverChain = new X509Certificate[0];
        }
    }
}

