/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.iot.client.impl.enterprise;

import com.oracle.iot.client.RestApi;
import com.oracle.iot.client.impl.enterprise.PageableEnumerator;
import com.oracle.iot.client.impl.http.HttpSecureConnection;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.GeneralSecurityException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public final class DeviceModelIterator
extends PageableEnumerator<String> {
    private final HttpSecureConnection secureConnection;
    private final String appId;
    private static final Logger LOGGER = Logger.getLogger("oracle.iot.client");

    public DeviceModelIterator(String appId, int offset, int limit, HttpSecureConnection secureConnection) throws IOException, GeneralSecurityException {
        super(offset, limit);
        this.appId = appId;
        this.secureConnection = secureConnection;
        this.setSize(this.getCount());
    }

    private int getCount() {
        try {
            DeviceModelRequest req = new DeviceModelRequest(this.appId, "count", this.offset, this.limit);
            JSONObject jsonObject = this.get(req.headers(), req.request());
            return jsonObject.optInt("count", -1);
        }
        catch (IOException ignored) {
        }
        catch (GeneralSecurityException generalSecurityException) {
            // empty catch block
        }
        return -1;
    }

    @Override
    protected PageableEnumerator.PagedResponse<String> load(int offset, int limit) throws IOException {
        DeviceModelRequest req = new DeviceModelRequest(this.appId, null, offset, limit);
        try {
            JSONObject object = this.get(req.headers(), req.request());
            return DeviceModelResponse.fromJson(object);
        }
        catch (JSONException e) {
            throw new IOException("GET " + req.request() + ": " + e.getMessage());
        }
        catch (GeneralSecurityException e) {
            throw new IOException("GET " + req.request() + ": " + e.getMessage());
        }
    }

    @Override
    protected HttpSecureConnection getSecureConnection() {
        return this.secureConnection;
    }

    private static Logger getLogger() {
        return LOGGER;
    }

    private static class DeviceModelResponse
    extends PageableEnumerator.PagedResponse<String> {
        private DeviceModelResponse(Collection<String> elements, int offset, int total, boolean hasMore, Map<String, String> links) {
            super(elements, offset, total, hasMore, links);
        }

        private static DeviceModelResponse fromJson(JSONObject jsonObject) throws JSONException {
            try {
                JSONArray items = (JSONArray)jsonObject.opt("items");
                JSONArray links = (JSONArray)jsonObject.opt("links");
                boolean hasMore = jsonObject.optBoolean("hasMore", false);
                int offset = jsonObject.optInt("offset", -1);
                int total = jsonObject.optInt("totalResults", -1);
                ArrayList<String> list = new ArrayList<String>();
                if (items != null) {
                    int size = items.length();
                    for (int i = 0; i < size; ++i) {
                        JSONObject model = (JSONObject)items.opt(i);
                        String urn = model.optString("urn", null);
                        if (urn == null) continue;
                        list.add(urn);
                    }
                }
                HashMap<String, String> map = new HashMap<String, String>();
                if (links != null) {
                    int size = links.length();
                    for (int i = 0; i < size; ++i) {
                        JSONObject object = (JSONObject)links.opt(i);
                        String rel = object.optString("rel", null);
                        String href = object.optString("href", null);
                        if (rel == null || href == null) continue;
                        map.put(rel, href);
                    }
                }
                return new DeviceModelResponse((Collection<String>)list, offset, total, hasMore, (Map<String, String>)map);
            }
            catch (ClassCastException e) {
                throw new JSONException("Incorrect response format");
            }
        }
    }

    static class DeviceModelRequest {
        private static final Map<String, String> headers = new HashMap<String, String>();
        private final String request;

        DeviceModelRequest(String appId, String path, int offset, int limit) {
            String query = "totalResults=true";
            String req = appId == null ? RestApi.V2.getReqRoot() : RestApi.V2.getReqRoot() + "/apps/" + appId;
            req = req + "/deviceModels";
            if (path != null) {
                req = req + "/" + path;
            }
            if (limit > 0) {
                query = query + "&limit=" + limit;
            }
            if (offset > 0) {
                query = query + "&offset=" + offset;
            }
            try {
                URI uri = new URI(null, null, req, query, null);
                this.request = uri.toString();
            }
            catch (URISyntaxException e) {
                DeviceModelIterator.getLogger().log(Level.SEVERE, e.toString());
                throw new RuntimeException(e);
            }
        }

        String request() {
            return this.request;
        }

        Map<String, String> headers() {
            return headers;
        }

        public String toString() {
            return "DeviceModelRequest: " + this.request();
        }

        static {
            headers.put("Content-Type", "application/json");
            headers.put("Accept", "application/json");
        }
    }
}

