/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.iot.client.impl.enterprise;

import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import oracle.iot.client.enterprise.Device;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class DeviceImpl
extends Device {
    private static final String DCD = "DIRECTLY_CONNECTED_DEVICE";
    private static final String ICD = "INDIRECTLY_CONNECTED_DEVICE";
    private static final String LOCATION_LATITUDE = "latitude";
    private static final String LOCATION_LONGITUDE = "longitude";
    private static final String LOCATION_ALTITUDE = "altitude";
    private static final String LOCATION_UNCERTAINTY = "uncertainty";
    private final Map<Device.Field, String> fields;
    private final boolean isDirectlyConnected;
    private final String id;
    private final List<String> deviceModels;
    private final Map<String, String> metadata;
    private final Device.Location location;

    private DeviceImpl(String id, Map<Device.Field, String> fields, List<String> deviceModels, Map<String, String> metadata, Device.Location location, boolean isDCD) {
        this.id = id;
        this.fields = fields;
        this.deviceModels = deviceModels;
        this.metadata = metadata;
        this.location = location;
        this.isDirectlyConnected = isDCD;
    }

    public static Device from(JSONObject object) throws JSONException {
        try {
            HashMap<Device.Field, String> fields = new HashMap<Device.Field, String>();
            Iterator keys = object.keys();
            while (keys.hasNext()) {
                String key = (String)keys.next();
                Device.Field f = Device.Field.fromAlias(key);
                if (f == null) continue;
                fields.put(f, object.opt(key).toString());
            }
            String t = (String)fields.get((Object)Device.Field.TYPE);
            boolean isDCD = t != null && t.equals(DCD);
            String id = (String)fields.get((Object)Device.Field.ID);
            JSONArray jsonModels = object.optJSONArray(Device.Field.DEVICE_MODELS.alias());
            LinkedList<String> deviceModels = new LinkedList<String>();
            if (jsonModels != null) {
                int size = jsonModels.length();
                for (int i = 0; i < size; ++i) {
                    String urn;
                    Object model = jsonModels.opt(i);
                    if (model instanceof JSONObject) {
                        JSONObject jsonObject = (JSONObject)model;
                        urn = jsonObject.getString("urn");
                    } else {
                        urn = model.toString();
                    }
                    deviceModels.add(urn);
                }
            }
            JSONObject jsonMetadata = object.optJSONObject(Device.Field.METADATA.alias());
            HashMap<String, String> metadata = new HashMap<String, String>();
            if (jsonMetadata != null) {
                keys = jsonMetadata.keys();
                while (keys.hasNext()) {
                    String key;
                    Object value = jsonMetadata.opt(key = (String)keys.next());
                    metadata.put(key, value != null ? value.toString() : "");
                }
            }
            JSONObject jsonLocation = object.optJSONObject(Device.Field.LOCATION.alias());
            float latitude = Float.NaN;
            float longitude = Float.NaN;
            float altitude = Float.NaN;
            float uncertainty = Float.NaN;
            if (jsonLocation != null) {
                keys = jsonLocation.keys();
                while (keys.hasNext()) {
                    String key = (String)keys.next();
                    if (key.equals(LOCATION_LATITUDE)) {
                        latitude = (float)jsonLocation.optDouble(key);
                        continue;
                    }
                    if (key.equals(LOCATION_LONGITUDE)) {
                        longitude = (float)jsonLocation.optDouble(key);
                        continue;
                    }
                    if (key.equals(LOCATION_ALTITUDE)) {
                        altitude = (float)jsonLocation.optDouble(key);
                        continue;
                    }
                    if (!key.equals(LOCATION_UNCERTAINTY)) continue;
                    uncertainty = (float)jsonLocation.optDouble(key);
                }
            }
            Device.Location location = new Device.Location(latitude, longitude, altitude, uncertainty);
            return new DeviceImpl(id, fields, deviceModels, metadata, location, isDCD);
        }
        catch (NullPointerException e) {
            throw new JSONException("Attribute 'type' or 'id' not found: " + object.toString());
        }
    }

    @Override
    public List<String> getDeviceModels() {
        return this.deviceModels;
    }

    @Override
    public String getValue(Device.Field field) {
        return this.fields.get((Object)field);
    }

    @Override
    public boolean isDirectlyConnected() {
        return this.isDirectlyConnected;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public Map<String, String> getMetadata() {
        return this.metadata;
    }

    @Override
    public String getMetadata(String key) {
        return this.metadata.get(key);
    }

    @Override
    public Device.Location getLocation() {
        return this.location;
    }

    private String toJson() {
        JSONObject builder = new JSONObject();
        try {
            builder.put("type", (Object)(this.isDirectlyConnected ? DCD : ICD)).put("id", (Object)this.id);
            for (Map.Entry<Device.Field, String> e : this.fields.entrySet()) {
                String alias = Device.Field.valueOf(((Object)((Object)e.getKey())).toString()).alias();
                builder.put(alias, (Object)e.getValue().toString());
            }
        }
        catch (JSONException e) {
            throw new RuntimeException(e);
        }
        return builder.toString();
    }

    public String toString() {
        return "Endpoint: " + this.toJson();
    }
}

