/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.iot.client.impl.enterprise;

import com.oracle.iot.client.enterprise.DeviceApp;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import oracle.iot.client.enterprise.Device;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class DeviceAppImpl
extends DeviceApp {
    private static final String DEVICE_APPLICATION = "DEVICE_APPLICATION";
    private final Map<DeviceApp.Field, String> fields;
    private final String id;
    private final List<String> deviceModels;
    private final Map<String, String> metadata;

    private DeviceAppImpl(String id, Map<DeviceApp.Field, String> fields, List<String> deviceModels, Map<String, String> metadata) {
        this.id = id;
        this.fields = fields;
        this.deviceModels = deviceModels;
        this.metadata = metadata;
    }

    public static DeviceApp from(JSONObject object) throws JSONException {
        EnumMap<DeviceApp.Field, String> fields = new EnumMap<DeviceApp.Field, String>(DeviceApp.Field.class);
        Iterator keys = object.keys();
        while (keys.hasNext()) {
            String key = (String)keys.next();
            DeviceApp.Field f = DeviceApp.Field.fromAlias(key);
            if (f == null) continue;
            fields.put(f, object.opt(key).toString());
        }
        String t = (String)fields.get((Object)DeviceApp.Field.TYPE);
        if (!DEVICE_APPLICATION.equals(t)) {
            throw new JSONException("Not a device Application: " + t);
        }
        String id = (String)fields.get((Object)DeviceApp.Field.ID);
        if (id == null) {
            throw new JSONException("Id is missing");
        }
        JSONArray jsonModels = object.optJSONArray(Device.Field.DEVICE_MODELS.alias());
        LinkedList<String> deviceModels = new LinkedList<String>();
        if (jsonModels != null) {
            int size = jsonModels.length();
            for (int i = 0; i < size; ++i) {
                String urn;
                Object model = jsonModels.opt(i);
                if (model instanceof JSONObject) {
                    JSONObject jsonObject = (JSONObject)model;
                    urn = jsonObject.getString("urn");
                } else {
                    urn = model.toString();
                }
                deviceModels.add(urn);
            }
        }
        JSONObject jsonMetadata = object.optJSONObject(Device.Field.METADATA.alias());
        HashMap<String, String> metadata = new HashMap<String, String>();
        if (jsonMetadata != null) {
            keys = jsonMetadata.keys();
            while (keys.hasNext()) {
                String key;
                Object value = jsonMetadata.opt(key = (String)keys.next());
                metadata.put(key, value != null ? value.toString() : "");
            }
        }
        return new DeviceAppImpl(id, fields, deviceModels, metadata);
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public String getMetadata(String key) {
        return this.metadata.get(key);
    }

    @Override
    public List<String> getDeviceModels() {
        return this.deviceModels;
    }

    @Override
    public Map<String, String> getMetadata() {
        return this.metadata;
    }

    @Override
    public String getValue(DeviceApp.Field field) {
        return this.fields.get((Object)field);
    }
}

