/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.iot.client.impl.enterprise;

import com.oracle.iot.client.RestApi;
import com.oracle.iot.client.impl.enterprise.ApplicationImpl;
import com.oracle.iot.client.impl.enterprise.PageableEnumerator;
import com.oracle.iot.client.impl.http.HttpSecureConnection;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.security.GeneralSecurityException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import oracle.iot.client.enterprise.Application;
import oracle.iot.client.enterprise.Filter;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class ApplicationEnumerator
extends PageableEnumerator<String> {
    private final HttpSecureConnection secureConnection;
    private final Filter filter;

    public ApplicationEnumerator(int offset, int limit, Filter filter, HttpSecureConnection secureConnection) throws IOException, GeneralSecurityException {
        super(offset, limit);
        this.filter = filter;
        this.secureConnection = secureConnection;
        this.setSize(this.getCount());
    }

    @Override
    protected HttpSecureConnection getSecureConnection() {
        return this.secureConnection;
    }

    private int getCount() {
        try {
            ApplicationEnumerationRequest req = new ApplicationEnumerationRequest(null, "count", this.filter, this.offset, this.limit);
            JSONObject jsonObject = this.get(req.headers(), req.request());
            return jsonObject.optInt("count", -1);
        }
        catch (IOException ignored) {
        }
        catch (GeneralSecurityException generalSecurityException) {
            // empty catch block
        }
        return -1;
    }

    @Override
    protected PageableEnumerator.PagedResponse<String> load(int offset, int limit) throws IOException {
        ApplicationEnumerationRequest req = new ApplicationEnumerationRequest(null, null, null, offset, limit);
        try {
            JSONObject jsonObject = this.get(req.headers(), req.request());
            return ApplicationEnumerationResponse.fromJson(jsonObject);
        }
        catch (Exception e) {
            throw new IOException("GET " + req.request() + ": " + e.getMessage());
        }
    }

    public static class ApplicationEnumerationResponse
    extends PageableEnumerator.PagedResponse<String> {
        ApplicationEnumerationResponse(Collection<String> appsId, int offset, int total, boolean hasMore, Map<String, String> links) {
            super(appsId, offset, total, hasMore, links);
        }

        public static ApplicationEnumerationResponse fromJson(JSONObject jsonObject) throws JSONException {
            try {
                JSONArray items = (JSONArray)jsonObject.opt("items");
                JSONArray links = (JSONArray)jsonObject.opt("links");
                boolean hasMore = jsonObject.optBoolean("hasMore", false);
                int offset = jsonObject.optInt("offset", -1);
                int total = jsonObject.optInt("totalResults", -1);
                ArrayList<String> list = new ArrayList<String>();
                if (items != null) {
                    int size = items.length();
                    for (int i = 0; i < size; ++i) {
                        Object item = items.opt(i);
                        Application app = ApplicationImpl.fromJson((JSONObject)item);
                        list.add(app.getId());
                    }
                }
                HashMap<String, String> map = new HashMap<String, String>();
                if (links != null) {
                    int size = links.length();
                    for (int i = 0; i < size; ++i) {
                        JSONObject object = (JSONObject)links.opt(i);
                        String rel = object.optString("rel", null);
                        String href = object.optString("href", null);
                        if (rel == null || href == null) continue;
                        map.put(rel, href);
                    }
                }
                return new ApplicationEnumerationResponse((Collection<String>)list, offset, total, hasMore, (Map<String, String>)map);
            }
            catch (ClassCastException e) {
                throw new JSONException("Incorrect response format");
            }
        }
    }

    public static class ApplicationEnumerationRequest {
        private static final Map<String, String> headers = new HashMap<String, String>();
        private final String request;

        public ApplicationEnumerationRequest(String applicationID, String path, Filter filter, int offset, int limit) {
            String req = RestApi.V2.getReqRoot() + "/apps";
            if (applicationID != null) {
                req = req + "/" + applicationID;
            }
            if (path != null) {
                req = req + "/" + path;
            }
            String sep = "?";
            if (limit > 0) {
                req = req + sep + "limit=" + limit;
                sep = "&";
            }
            if (offset > 0) {
                req = req + sep + "offset=" + offset;
                sep = "&";
            }
            if (filter != null) {
                try {
                    String query = "q=" + URLEncoder.encode(filter.toJson().toString(), "UTF8");
                    req = req + sep + query;
                }
                catch (UnsupportedEncodingException ignored) {
                    // empty catch block
                }
            }
            this.request = req;
        }

        public String request() {
            return this.request;
        }

        public Map<String, String> headers() {
            return headers;
        }

        static {
            headers.put("Content-Type", "application/json");
            headers.put("Accept", "application/json");
        }
    }
}

