/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.iot.client.enterprise;

import com.oracle.iot.client.impl.enterprise.MessageIterator;
import com.oracle.iot.client.impl.enterprise.MessagePoller;
import com.oracle.iot.client.impl.enterprise.SecureHttpConnectionMap;
import com.oracle.iot.client.impl.http.HttpSecureConnection;
import com.oracle.iot.client.message.Message;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.util.Collection;
import oracle.iot.client.enterprise.EnterpriseClient;
import oracle.iot.client.enterprise.Pageable;

public class MessageEnumerator {
    private static final int MIN_PAGE_SIZE = 10;
    private static final int MAX_PAGE_SIZE = 200;
    private static final int limit;
    private final HttpSecureConnection secureConnection;
    private final String appID;

    public MessageEnumerator(EnterpriseClient client) {
        if (client == null) {
            throw new NullPointerException();
        }
        String id = null;
        if (client.getApplication() != null) {
            id = client.getApplication().getId();
        }
        this.appID = id;
        this.secureConnection = SecureHttpConnectionMap.getSecureHttpConnection(client);
    }

    public Pageable<Message> getMessages(String deviceID, Message.Type type, boolean expand, long since, long until) throws IOException, GeneralSecurityException {
        return new MessageIterator(this.appID, 0, limit, deviceID, type, expand, since, until, this.secureConnection, false);
    }

    public void setListener(String deviceId, Message.Type type, MessageListener listener) throws IllegalStateException, IOException, GeneralSecurityException {
        MessagePoller.setListener(this.appID, this.secureConnection, deviceId, type, listener);
    }

    static {
        Integer val = Integer.getInteger("oracle.iot.client.enterprise.message_enumerator_limit");
        limit = val != null ? Math.min(200, Math.max(10, val)) : 10;
    }

    public static interface MessageListener {
        public void notify(Collection<Message> var1);
    }
}

