/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.iot.client.enterprise;

import com.oracle.iot.client.RestApi;
import com.oracle.iot.client.enterprise.DeviceApp;
import com.oracle.iot.client.impl.enterprise.DeviceAppImpl;
import com.oracle.iot.client.impl.enterprise.PageableEnumerator;
import com.oracle.iot.client.impl.enterprise.SecureHttpConnectionMap;
import com.oracle.iot.client.impl.http.HttpSecureConnection;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.GeneralSecurityException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;
import oracle.iot.client.enterprise.EnterpriseClient;
import oracle.iot.client.enterprise.Filter;
import oracle.iot.client.enterprise.Pageable;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public final class DeviceAppEnumerator {
    private final HttpSecureConnection secureConnection;
    private final String appID;
    private static final Logger LOGGER = Logger.getLogger("oracle.iot.client");

    public DeviceAppEnumerator(EnterpriseClient client) {
        if (client == null) {
            throw new NullPointerException();
        }
        String id = null;
        if (client.getApplication() != null) {
            id = client.getApplication().getId();
        }
        this.appID = id;
        this.secureConnection = SecureHttpConnectionMap.getSecureHttpConnection(client);
    }

    public Pageable<DeviceApp> getDeviceApps(Filter filter) throws IOException, GeneralSecurityException {
        return new DeviceAppPageable(this.appID, 0, 10, filter, this.secureConnection);
    }

    private static Logger getLogger() {
        return LOGGER;
    }

    private static class DeviceAppEnumerationResponse
    extends PageableEnumerator.PagedResponse<DeviceApp> {
        private DeviceAppEnumerationResponse(Collection<DeviceApp> deviceApps, int offset, int total, boolean hasMore, Map<String, String> links) {
            super(deviceApps, offset, total, hasMore, links);
        }

        private static DeviceAppEnumerationResponse fromJson(JSONObject jsonObject) throws JSONException {
            try {
                JSONArray items = jsonObject.optJSONArray("items");
                JSONArray links = jsonObject.optJSONArray("links");
                boolean hasMore = jsonObject.optBoolean("hasMore", false);
                int offset = jsonObject.optInt("offset", -1);
                int total = jsonObject.optInt("totalResults", -1);
                ArrayList<DeviceApp> list = new ArrayList<DeviceApp>();
                if (items != null) {
                    int size = items.length();
                    for (int i = 0; i < size; ++i) {
                        Object item = items.opt(i);
                        list.add(DeviceAppImpl.from((JSONObject)item));
                    }
                }
                HashMap<String, String> map = new HashMap<String, String>();
                if (links != null) {
                    int size = links.length();
                    for (int i = 0; i < size; ++i) {
                        JSONObject object = (JSONObject)links.opt(i);
                        String rel = object.optString("rel", null);
                        String href = object.optString("href", null);
                        if (rel == null || href == null) continue;
                        map.put(rel, href);
                    }
                }
                return new DeviceAppEnumerationResponse((Collection<DeviceApp>)list, offset, total, hasMore, (Map<String, String>)map);
            }
            catch (ClassCastException e) {
                throw new JSONException("Incorrect response format");
            }
        }
    }

    private static class DeviceAppEnumerationRequest {
        private static final Map<String, String> HEADERS = new HashMap<String, String>();
        private final String request;

        private DeviceAppEnumerationRequest(String applicationID, String path, int offset, int limit, Filter filter) {
            int queryPos;
            String sep = "?";
            String req = applicationID == null ? RestApi.V2.getReqRoot() : RestApi.V2.getReqRoot() + "/apps/" + applicationID;
            req = req + "/deviceApps";
            if (path != null) {
                req = req + "/" + path;
            }
            if (limit > 0) {
                req = req + sep + "limit=" + limit;
                sep = "&";
            }
            if (offset > 0) {
                req = req + sep + "offset=" + offset;
                sep = "&";
            }
            req = req + sep + "totalResults=true";
            if (filter != null) {
                req = req + "&q=";
                req = req + filter.toString();
            }
            if ((queryPos = req.indexOf(63)) > 0) {
                String p = req.substring(0, queryPos);
                String query = req.substring(queryPos + 1, req.length());
                try {
                    URI uri = new URI(null, null, p, query, null);
                    req = uri.toString();
                }
                catch (URISyntaxException e) {
                    DeviceAppEnumerator.getLogger().severe(e.toString());
                }
            }
            this.request = req;
        }

        public String request() {
            return this.request;
        }

        public Map<String, String> headers() {
            return HEADERS;
        }

        static {
            HEADERS.put("Content-Type", "application/json");
            HEADERS.put("Accept", "application/json");
        }
    }

    private static final class DeviceAppPageable
    extends PageableEnumerator<DeviceApp> {
        private final Filter filter;
        private final String appID;
        private final HttpSecureConnection secureConnection;

        public DeviceAppPageable(String appID, int offset, int limit, Filter filter, HttpSecureConnection secureConnection) throws IOException, GeneralSecurityException {
            super(offset, limit);
            this.appID = appID;
            this.filter = filter;
            this.secureConnection = secureConnection;
            this.setSize(this.getCount());
        }

        private int getCount() {
            DeviceAppEnumerationRequest req = new DeviceAppEnumerationRequest(this.appID, "count", this.offset, this.limit, this.filter);
            try {
                JSONObject jsonObject = this.get(req.headers(), req.request());
                return jsonObject.optInt("count", -1);
            }
            catch (IOException ignored) {
            }
            catch (GeneralSecurityException generalSecurityException) {
                // empty catch block
            }
            return -1;
        }

        @Override
        protected HttpSecureConnection getSecureConnection() {
            return this.secureConnection;
        }

        @Override
        protected PageableEnumerator.PagedResponse<DeviceApp> load(int offset, int limit) throws IOException {
            DeviceAppEnumerationRequest req = new DeviceAppEnumerationRequest(this.appID, null, offset, limit, this.filter);
            try {
                JSONObject jsonObject = this.get(req.headers(), req.request());
                return DeviceAppEnumerationResponse.fromJson(jsonObject);
            }
            catch (JSONException e) {
                throw new IOException("GET " + req.request() + ": " + e.getMessage());
            }
            catch (GeneralSecurityException e) {
                throw new IOException("GET " + req.request() + ": " + e.getMessage());
            }
        }
    }
}

