/*
 *  Copyright © 2016, 2017, Oracle and/or its affiliates. All rights reserved.
 *  This software is dual-licensed to you under the MIT License (MIT) and
 *  the Universal Permissive License (UPL). See the LICENSE file in the root
 *  directory for license terms. You may choose either license, or both.
 */

import UIKit

class PasswordView: UIViewController, UITextFieldDelegate {
    
    @IBOutlet weak var passwordOutlet: UITextField!
    @IBOutlet weak var okButtonOutlet: UIButton!
    
    private var passwordcount: Int = 0
    private var disappearing: Bool = false;

    override func viewDidLoad() {
        self.passwordOutlet.delegate = self
        super.viewDidLoad()
    }

    override func viewWillAppear(_ animated: Bool) {
        //okButtonOutlet.isEnabled = false
        passwordOutlet.becomeFirstResponder()
        passwordcount = 0
        super.viewWillAppear(animated)
    }
    override func viewDidAppear(_ animated: Bool) {
        disappearing = false
        super.viewDidAppear(animated)
    }
    
    override func viewWillDisappear(_ animated: Bool) {
        disappearing = true
        super.viewWillDisappear(animated)
    }
    
    override func viewDidDisappear(_ animated: Bool) {
        passwordcount = 0
        super.viewDidDisappear(animated)
    }

    override func didReceiveMemoryWarning() {
        super.didReceiveMemoryWarning()
        // Dispose of any resources that can be recreated.
    }
    
    // Not used anymore. Navigates on the return key, called "Continue"
    @IBAction func okButton(_ sender: UIButton) {
        //handleOk(button: sender)
    }
    
    @objc func getPassword() -> String {
        return passwordOutlet.text!
    }
    
    // PaswordView methods
    // Sublclasses must implement verifyPassword and return true to 
    // move to the next view
    @objc func verifyPassword(password: String) -> Bool {
        return false
    }

    // Subclasses implement this method to handle the ok button
    @objc func handleOk(button: UIButton) {
    }

    @objc func passwordTryAgain(action: UIAlertAction) {
        self.passwordOutlet.becomeFirstResponder()
    }
    
    @objc func passwordCancel(action: UIAlertAction) {
        cancelPassword()
    }
    
    @objc func cancelPassword() {
        let _ = self.navigationController?.popToRootViewController(animated: false)
    }
    
    func textFieldShouldReturn(_ userText: UITextField) -> Bool {
        userText.resignFirstResponder()
        userText.endEditing(true)
        return false;
    }
    
    /**
     * Check trusted asset store to determine if asset is already provisioned
     */
    func textFieldDidEndEditing(_ textField: UITextField) {
        if disappearing {
            return
        }
        if !verifyPassword(password: textField.text!) {
            self.passwordcount += 1
            if passwordcount == 3 {
                cancelPassword()
                return
            }
            // post error alert, ask to try again, for 3 attempts
            let alertController = UIAlertController(title: "Provisioning Alert",
                                                    message: "The password is not correct",
                                                    preferredStyle: .alert)
            
            alertController.addAction(UIAlertAction(title: "Try Again", style: .default,
                                                    handler: self.passwordTryAgain))
            
            
            alertController.addAction(UIAlertAction(title: "Cancel", style: .default,
                                                    handler: self.passwordCancel))
            
            self.present(alertController, animated: true, completion: nil)
            return
        } else {
            //self.okButtonOutlet.isEnabled = true
            handleOk(button: self.okButtonOutlet)
        }
    }
}

