/*
 *  Copyright © 2016 Oracle and/or its affiliates. All rights reserved.
 *  This software is dual-licensed to you under the MIT License (MIT) and
 *  the Universal Permissive License (UPL). See the LICENSE file in the root
 *  directory for license terms. You may choose either license, or both.
 */

import Foundation

#if ENTERPRISE_APP
import EnterpriseLib
#else
import DeviceLib
#endif

// TODO: Find a better model for utilizing library code
// like the TAM with View based implementation like the
// provisioning code.
func validateTam(path: String, password: String) -> Bool {
    do {
        let tam = try TrustedAssetsManagerFactory.getTrustedAssetsManager(
            path: path, password: password)!
        
        let deviceID = tam.getClientId()
        let serverHost = tam.getServerHost()
        
        if serverHost.isEmpty || deviceID.isEmpty {
            return false
        } else {
            return true
        }
    } catch {
        print (error)
        return false
    }
}

// TODO: Fix library specific linkage in shared code
func getNetworkClientError(error: String) -> Error {
    return ClientError.network(error)
}
