/*
 *  Copyright © 2016, 2017, Oracle and/or its affiliates. All rights reserved.
 *  This software is dual-licensed to you under the MIT License (MIT) and
 *  the Universal Permissive License (UPL). See the LICENSE file in the root
 *  directory for license terms. You may choose either license, or both.
 */

import UIKit

class ImageLibraryView: UIViewController,
                        UIImagePickerControllerDelegate,
                        UINavigationControllerDelegate {
    
    @IBOutlet var imageView:UIImageView?
    
    @objc let picker:UIImagePickerController = UIImagePickerController()
    
    override func viewDidLoad() {
        super.viewDidLoad()
        picker.delegate = self
    }
        
    override func viewWillAppear(_ animated:Bool) {
        super.viewWillAppear(animated)
    }
    override func viewDidAppear(_ animated: Bool) {
        super.viewDidAppear(animated)
        /*
        if !UIImagePickerController.isSourceTypeAvailable(.camera)  {
            // There is not a camera on this device, so don't show the camera button.
            let toolbar:UIToolbar = self.navigationController!.toolbar
            var toolbarItems:Array = toolbar.items!
            if toolbarItems.count > 2 {
                toolbarItems.remove(at: 2)
                setToolbarItems(toolbarItems, animated:false)
            }
        }
        */
    }
    
    override func viewWillDisappear(_ animated:Bool) {
        super.viewWillDisappear(animated)
    }

    @IBAction func onImagesAction(_ sender: UIButton) {
        picker.allowsEditing = false
        //picker.showsCameraControls = false
        //picker.cameraCaptureMode = .photo
        /*
        if UIImagePickerController.isSourceTypeAvailable(.savedPhotosAlbum) {
            picker.sourceType = .savedPhotosAlbum
            picker.mediaTypes = UIImagePickerController.availableMediaTypes(
                for: .savedPhotosAlbum)!
            print ("Can use .savedPhotosAlbum")
        }
        */
        if UIImagePickerController.isSourceTypeAvailable(.photoLibrary) {
            picker.sourceType = .photoLibrary
            picker.mediaTypes = UIImagePickerController.availableMediaTypes(
                for: .photoLibrary)!
            print ("Can use .photoLIbrary")
        }

        modalPresentationStyle = .popover
            //.none //.overCurrentContext //.overFullScreen //.popover
        present(picker, animated: true, completion: {
            print ("#### In present completion ###")
        })
    }

    //MARK: - Delegates
    func imagePickerControllerDidCancel(_ picker: UIImagePickerController) {
        dismiss(animated: true, completion: nil)
    }

    private func imagePickerController(_ picker: UIImagePickerController,
            didFinishPickingMediaWithInfo info: [String : AnyObject]) {
        /*
        func UIImageWriteToSavedPhotosAlbum(_ image: UIImage,
                                            _ completionTarget: Any?,
                                            _ completionSelector: Selector?,
                                            _ contextInfo: UnsafeMutableRawPointer?)
         func UISaveVideoAtPathToSavedPhotosAlbum(_ videoPath: String,
         _ completionTarget: Any?,
         _ completionSelector: Selector?,
         _ contextInfo: UnsafeMutableRawPointer?)
         
        */
        let chosenImage =
            info[UIImagePickerControllerOriginalImage] as! UIImage
        imageView?.contentMode = .scaleAspectFit
        imageView?.image = chosenImage
        dismiss(animated:true, completion: nil)
    }
}
