/*
 *  Copyright © 2016 Oracle and/or its affiliates. All rights reserved.
 *  This software is dual-licensed to you under the MIT License (MIT) and
 *  the Universal Permissive License (UPL). See the LICENSE file in the root
 *  directory for license terms. You may choose either license, or both.
 */

import Foundation
import EnterpriseLib

/* The device models supported by this Sample */
let HUMIDITY_SENSOR_DEVICE_MODEL_URN = "urn:com:oracle:iot:device:humidity_sensor"
let TEMPERATURE_SENSOR_DEVICE_MODEL_URN = "urn:com:oracle:iot:device:temperature_sensor"
let IBEACON_DEVICE_MODEL_URN = "urn:com:oracle:iot:device:location:ibeacon"
let EDDYSTONEBEACONTLMUID_DEVICE_MODEL_URN = "urn:com:oracle:iot:device:location:eddystone-tlm-uid"
let MOTIONACTIVATEDCAMERA_DEVICE_MODEL_URN = "urn:com:oracle:iot:device:motion_activated_camera"

var applicationName:String = ""

var dmArray: Array<String> = []
var urnArray: Array<String> = []
var appDeviceModelsList: Array<DeviceModel> = []
var activeDevices: Array<VirtualDevice> = []
var deviceNameArray: Array<String> = []
var deviceIdArray: Array<String> = []
var deviceTypeArray: Array<String> = []

var deviceManufacturers: Array<String> = []
var deviceModelNumbers: Array<String> = []
var deviceSerialNumbers: Array<String> = []

var deviceUUID: Array<String> = []
var deviceMinor: Array<String> = []
var deviceMajor: Array<String> = []

var maxThresholds:[Int32] = []
var minThresholds:[Int32] = []

var monitoredDevice:String = ""
var monitoredDeviceManufacturer = ""
var monitoredDeviceModelNumber = ""
var monitoredDeviceSerialNumber = ""

var monitoredDeviceUUID = ""
var monitoredDeviceMajor = ""
var monitoredDeviceMinor = ""

var humidity: Int32 = 0
var humidityThreshold: Int32 = 80
var temperature: Double = 0.0
var rssi: Double = 0.0
var minTemperature: Double = 0.0
var maxTemperature: Double = 0.0
var temperatureMinThreshold: Int32 = 0
var temperatureMaxThreshold: Int32 = 70
var lastOn: String = ""
var unit: String = "\u{00B0}C"

var mssi: Int32 = 0
var voltage: Double = 0.0

var ecl: EnterpriseClient!
