/*
 * Copyright (c) 2017, Oracle and/or its affiliates. All rights reserved.
 *
 * This software is dual-licensed to you under the MIT License (MIT) and
 * the Universal Permissive License (UPL). See the LICENSE file in the root
 * directory for license terms. You may choose either license, or both.
 */

#pragma once

#include <string>

/**
 * @file DeviceModel.hpp
 * @brief Detailed information on a device model. A device model is a specification
 * of the attributes, formats, and resources available on the device.
 */
namespace iotdcl {
    class DeviceModel {
    public:
        /**
         * @brief Get the URN of the device model
         *
         * @return the URN of the model
         */
        virtual const std::string getURN() const = 0;

        /**
         * @brief Get the name of the device model
         * @return the device model name
         */
        virtual const std::string getName() const = 0;

        /**
         * @brief Get the free form description of the device model
         *
         * @return the description of the model
         */
        virtual const std::string getDescription() const = 0;

        virtual ~DeviceModel() {}
    };
};
