/*
 * Copyright (c) 2016, Oracle and/or its affiliates. All rights reserved.
 *
 * This software is dual-licensed to you under the MIT License (MIT) and
 * the Universal Permissive License (UPL). See the LICENSE file in the root
 * directory for license terms. You may choose either license, or both.
 */

#ifndef IOTCS_PORT_TIME_H
#define	IOTCS_PORT_TIME_H

#ifdef	__cplusplus
extern "C" {
#endif

#include "iotcs_port_system.h"

#define IOTCS_NANOSEC_IN_SEC 1000000000L

#define IOTCS_TIMEVAL_TO_MILLISEC(tv) \
    (IOTCS_SEC_TO_MILLISEC((tv)->tv_sec) + IOTCS_MICROSEC_TO_MILLISEC((tv)->tv_usec))
    
#define IOTCS_TIMESPEC_TO_MILLISEC(ts) \
    (IOTCS_SEC_TO_MILLISEC((ts)->tv_sec) + IOTCS_NANOSEC_TO_MILLISEC((ts)->tv_nsec))

#define IOTCS_MILLISEC_TO_TIMESPEC(msec, ts) \
    do { \
        (ts)->tv_sec = IOTCS_MILLISEC_TO_SEC(msec); \
        (ts)->tv_nsec = IOTCS_MILLISEC_TO_NANOSEC((msec) % 1000); \
    } while (0)

int gettimeofday(struct timeval *tv, struct timezone *tz);
void timeradd(struct timeval *a, struct timeval *b, struct timeval *res);
void timersub(struct timeval *a, struct timeval *b, struct timeval *res);

#ifdef	__cplusplus
}
#endif

#endif	/* IOTCS_PORT_TIME_H */