# 
# Copyright (c) 2015, 2016, Oracle and/or its affiliates. All rights reserved.
#
# This software is dual-licensed to you under the MIT License (MIT) and the Universal Permissive License (UPL).  See the LICENSE file in the root directory for license terms.  You may choose
# either license, or both.
#

CFLAGS+=$(INCLUDE_OPT)$(OPENSSL)/include
CFLAGS+=/nologo /Gy /Gm- /errorReport:prompt /Oy- /Oi /MT
ifeq ($(DEBUG),true)
    CFLAGS+=/GS-
else
    CFLAGS+=/GL /O2 /analyze- /sdl
endif
CFLAGS+=/D_CRT_SECURE_NO_WARNINGS /D_CRT_SECURE_NO_DEPRECATE /D_CRT_NONONSTDC_NO_DEPRECATE /D_WINSOCK_DEPRECATED_NO_WARNINGS /wd4996 /wd4711 /wd4127
CFLAGS+=/Dsnprintf=_snprintf /Dstrcasecmp=_stricmp /Dstrnicmp=_strnicmp /Dstrncasecmp=_strnicmp /D__func__=__FUNCTION__

LDFLAGS+=/link /DYNAMICBASE /NOLOGO /INCREMENTAL /IGNORE:4711

# object Files of porting part
OBJ_PORT =                                    \
    $(PORT_OBJ_DIR)/iotcs_port_crypto.o       \
    $(PORT_OBJ_DIR)/iotcs_port_system.o       \
    $(PORT_OBJ_DIR)/iotcs_port_ssl.o          \
    $(PORT_OBJ_DIR)/iotcs_hostname_verifier.o \
    $(PORT_OBJ_DIR)/iotcs_port_thread.o       \
    $(PORT_OBJ_DIR)/iotcs_port_memory.o       \
    $(PORT_OBJ_DIR)/iotcs_port_diagnostic.o   \
    $(PORT_OBJ_DIR)/iotcs_port_queue.o

ifneq ($(DISABLE_MQTT), true)
    OBJ_PORT+=$(PORT_OBJ_DIR)/iotcs_port_mqtt.o
endif

TAM_OBJ_PORT =                                \
    $(PORT_TAM_OBJ_DIR)/iotcs_port_tam.o

# include all needed to build windows library
-include $(PORT_IMPLPATH)/download.mk
include $(PORT_IMPLPATH)/windows.mk
