# 
# Copyright (c) 2017, Oracle and/or its affiliates. All rights reserved.
#
# This software is dual-licensed to you under the MIT License (MIT) and the Universal Permissive License (UPL).  See the LICENSE file in the root directory for license terms.  You may choose
# either license, or both.
#

#
#  Targets:
#
#     clean             cleans the build
#     build             builds bootstrapper
#

# path prefix for platform toolchain (gcc, ar, etc)
TOOLS_PREFIX?=
DEBUG?=true
LINK_ICONV?=false

BOOTSTRAPPER_NAME=bootstrapper
BOOTSTRAPPER_SOURCE=$(SRC_DIR)/bootstrapper/$(PORT)/$(BOOTSTRAPPER_NAME).c

# executable extension
EXEC_EXTENSION=.exe
BOOTSTRAPPER_EXECUTABLE=$(BOOTSTRAPPER_NAME)$(EXEC_EXTENSION)

BOOTSTRAPPER_DIR=$(OUTPUT_DIR)/$(PORT)$(DEBUG_SUFFIX)/bootstrapper
BOOTSTRAPPER_RUNTIME_LIBS =   \
	$(OPENSSL_LIBS)    \
	crypt32.lib        \
	Ws2_32.lib         \
	kernel32.lib       \
	user32.lib         \
	gdi32.lib          \
	winspool.lib       \
	comdlg32.lib       \
	advapi32.lib       \
	shell32.lib        \
	ole32.lib          \
	oleaut32.lib       \
	uuid.lib           \
	odbc32.lib         \
	odbccp32.lib

_LD_LIBS=/LIBPATH:$(BOOTSTRAPPER_RUNTIME_LIBS)
_CPP_FLAGS=/W3 /WX-
_C_FLAGS=/I$(PORT_SRC_DIR)/openssl/include /nologo /Gy /Gm- /errorReport:prompt /Oy- /Oi /MT /GS- /D_CRT_SECURE_NO_WARNINGS /D_CRT_SECURE_NO_DEPRECATE /D_CRT_NONONSTDC_NO_DEPRECATE /D_WINSOCK_DEPRECATED_NO_WARNINGS /wd4996 /wd4711 /wd4127 /Dsnprintf=_snprintf /Dstrcasecmp=_stricmp /Dstrnicmp=_strnicmp /Dstrncasecmp=_strnicmp /D__func__=__FUNCTION__
_LD_FLAGS=/link /DYNAMICBASE /NOLOGO /INCREMENTAL /IGNORE:4711

.PHONY: bootstrapper
bootstrapper: .windows_impl
	mkdir -p $(OUT_BOOTSTRAPPER_DIR)
	$(CC) $(_C_FLAGS) $(_CPP_FLAGS) $(BOOTSTRAPPER_SOURCE) $(_LD_FLAGS) $(_LD_LIBS) /OUT:$(OUT_BOOTSTRAPPER_DIR)/$(BOOTSTRAPPER_EXECUTABLE)
