/*
 * Copyright (c) 2017, Oracle and/or its affiliates. All rights reserved.
 *
 * This software is dual-licensed to you under the MIT License (MIT) and
 * the Universal Permissive License (UPL). See the LICENSE file in the root
 * directory for license terms. You may choose either license, or both.
 */

#pragma once
#include <AbstractVirtualDevice.hpp>
#include <string>

/* include iot cs device model APIs */
#include "iotcs_virtual_device.h"

namespace iotdcl {
    class AlertImpl : public Alert {
    public:
        static Alert* createAlert(VirtualDevice* device, iotcs_virtual_device_handle handler, const std::string &alertName);
    private:
        AlertImpl();
        AlertImpl(VirtualDevice* device, iotcs_virtual_device_handle handler, const std::string &alertName);
    };
};