/*
 * Copyright (c) 2017, Oracle and/or its affiliates. All rights reserved.
 *
 * This software is dual-licensed to you under the MIT License (MIT) and
 * the Universal Permissive License (UPL). See the LICENSE file in the root
 * directory for license terms. You may choose either license, or both.
 */

#include <string>
#include "ExternalObject.hpp"
#include "iotcs_storage_object.h"

namespace iotdcl {
    static std::string emptyString = "";
    ExternalObject::~ExternalObject() {
        if (storage_object_handle) {
            iotcs_free_external_object_handle(storage_object_handle);
            storage_object_handle = NULL;
        }
        if (this->uri) {
            delete this->uri;
        }
    }

    ExternalObject::ExternalObject(const std::string& uri) {
        this->uri = new std::string(uri);
        storage_object_handle = NULL;
        iotcs_create_external_object_handle(uri.c_str(), &storage_object_handle);
    }

    const std::string& ExternalObject::getURI() const {
        if (uri) {
            return *uri;
        } else {
            return emptyString;
        }
    }
};
