/*
 * Copyright (c) 2017, Oracle and/or its affiliates. All rights reserved.
 *
 * This software is dual-licensed to you under the MIT License (MIT) and
 * the Universal Permissive License (UPL). See the LICENSE file in the root
 * directory for license terms. You may choose either license, or both.
 */

#pragma once

#include <stdexcept>
#include <string>
#include "iotcs.h"

#ifndef _MSC_VER
#define NOEXCEPT noexcept
#else
#define NOEXCEPT
#endif

namespace iotdcl {
    /**
     * @brief Thrown on problems with authorization
     */
    class CanNotAuthorizeException : public std::exception {
    public:
        const char * what () const NOEXCEPT {
            return "Can not authorize exception";
        }
    };
    /**
     * @brief Common exception
     */
    class GeneralException : public std::exception {
    public:
        const char * what () const NOEXCEPT {
            return "General security exception";
        }
    };
};
