/*
 * Copyright (c) 2017, Oracle and/or its affiliates. All rights reserved.
 *
 * This software is dual-licensed to you under the MIT License (MIT) and
 * the Universal Permissive License (UPL). See the LICENSE file in the root
 * directory for license terms. You may choose either license, or both.
 */

#pragma once
#include "iotcs.h"
#include "iotcs_virtual_device.h"
#include <AbstractVirtualDevice.hpp>

namespace iotdcl {
    class ErrorEventImpl: public ErrorEvent<VirtualDevice> {
        const VirtualDevice *vd;
        NamedValue *value;
        const std::string* msg;
        public:
            ErrorEventImpl(const VirtualDevice *vd, NamedValue *value, const std::string *msg) {
                this->vd = vd;
                this->value = value;
                this->msg = msg;
            }

            const VirtualDevice& getVirtualDevice() const {
                return *vd;
            }

            NamedValue* getNamedValue() const {
                return value;
            }

            const std::string getMessage() const {
                return *msg;
            }

            ~ErrorEventImpl() {
            }
    };
};
