/*
 * Copyright (c) 2017, Oracle and/or its affiliates. All rights reserved.
 *
 * This software is dual-licensed to you under the MIT License (MIT) and
 * the Universal Permissive License (UPL). See the LICENSE file in the root
 * directory for license terms. You may choose either license, or both.
 */

#pragma once
#include <string>
#include <DeviceModel.hpp>
#include <AbstractVirtualDevice.hpp>

namespace iotdcl {
    class DeviceModelImpl : public DeviceModel {
        public:        
            virtual const std::string getURN() const;
            virtual const std::string getName() const;
            virtual const std::string getDescription() const;
            DeviceModelImpl(const std::string &urn);
            DeviceModelImpl(const DeviceModelImpl &dm);
            virtual ~DeviceModelImpl();
            iotcs_device_model_handle handle;
    };
};
