# 
# Copyright (c) 2017, 2018, Oracle and/or its affiliates. All rights reserved.
#
# This software is dual-licensed to you under the MIT License (MIT) and the Universal Permissive License (UPL).  See the LICENSE file in the root directory for license terms.  You may choose
# either license, or both.
#

## variable depending on the configuration ##
# used for verbose output log
ifneq ($(VERBOSE),true)
	A=@
else
	V=-v
endif

## base directories ##
OUTPUT_DIR=$(CPP_PROJ_DIR)/build
VRT_SUBDIR=virtualization

# documentation files
DOC_VERSION_FILE=version
DOC_FILES=$(CPP_INC_DIR)/*
CPPFLAGS+=$(WARN_LVL_OPT) $(CPPINCLUDES) $(COMPILE_OPT)

# device virtualization API Headers
_CPP_VIRTUALIZATION_API_HEADERS =                  \
	AbstractVirtualDevice.hpp                      \
	Alert.hpp                                      \
	Exception.hpp                                  \
	Data.hpp                                       \
	DeviceModel.hpp                                \
	DirectlyConnectedDevice.hpp                    \
	GatewayDevice.hpp                              \
	NamedValue.hpp                                 \
	StorageObject.hpp                              \
	ExternalObject.hpp                             \
	VirtualDevice.hpp

# documentation variables
DOXYGEN?=doxygen
VRT_API_DOC_PART?=E92477-02
MSG_API_DOC_PART?=XXXXXXXXX
PRT_API_DOC_PART?=XXXXXXXXX
PLATFORM_API='C++'
VRT_API='Device Virtualization'

CPP_VIRTUALIZATION_API_HEADERS = $(patsubst %,$(CPP_INC_DIR)/%,$(_CPP_VIRTUALIZATION_API_HEADERS))

OUT_DOC_SUBDIR=apidocs

## output variables ##
LINE_TRAP="===================================================="
define SCM
/**\n
endef
define CMT
 *
endef
define ECM
\n */\n
endef
LIB_EXT=a
SHORT_LIB_NAME=iotdc
SHORT_TAM_LIB_NAME=tam
OUT_LIB_NAME=lib$(SHORT_LIB_NAME).$(LIB_EXT)
OUT_TAM_LIB_NAME=lib$(SHORT_TAM_LIB_NAME).$(LIB_EXT)

## temporary directories ##
TMP_DIR=$(OUTPUT_DIR)/tmp
# documentation directories
TMP_VRT_DOC_SUBDIR=vrt_doc_src

# object files
_CPP_VIRT_OBJ_FILE_NAMES =           \
	device_model/DeviceModelImpl.o   \
	device_model/NamedValue.o        \
	iotcs/DirectlyConnectedDevice.o  \
	iotcs/GatewayDevice.o            \
	iotcs/VirtualDeviceImpl.o        \
	messaging/AlertImpl.o            \
	messaging/DataImpl.o             \
	scs/StorageObject.o              \
	scs/StorageObjectImpl.o          \
	scs/ExternalObject.o             \
	util/cpputil.o

ifeq ($(VIRTUALIZATION_SUPPORT), true)
	OBJ_FILES=$(patsubst %,$(OBJ_DIR)/%,$(_CPP_VIRT_OBJ_FILE_NAMES))
endif

include $(LIB_COMMON_DEFS)

PLATFORM_API='CPP'
CPPINCLUDES+=$(INCLUDE_OPT)$(CPP_INC_DIR) $(INCLUDE_OPT)$(CPP_SHARED_DIR)
DOC_DIR=$(CPP_PROJ_DIR)/make/doxygen
ifeq ($(PORT),mbed)
	CXXCOMMNAD=$(A)$(CXX) $(CPPFLAGS) $(CPP_OPTS) $(CXXFLAGS) $(CXX_OPTS) $(INCLUDE_OPT)$(MBED_INC_DIR) $(OBJECT_FILE_NAME_OPT)$@ $<  $(LDFLAGS) $(LD_OPTS) $(LDLIBS)
else
	CXXCOMMNAD=$(A)$(CXX) $(CPPFLAGS) $(CFLAGS) $(CPP_OPTS) $(CXXFLAGS) $(CXX_OPTS) $(OBJECT_FILE_NAME_OPT)$@ $<  $(LDFLAGS) $(LD_OPTS) $(LDLIBS)
endif

# targets for compile shared sources
$(OBJ_DIR)/%.o: $(CPP_SHARED_DIR)/%.cpp
	$(A)mkdir -p $(dir $@)
	$(CXXCOMMNAD)

$(OBJ_DIR)/%.obj: $(CPP_SHARED_DIR)/%.cpp
	$(A)mkdir -p $(dir $@)
	$(CXXCOMMNAD)

# documentation related targets
.pre_doc_cpp: $(OUTPUT_DIR)
	@printf "\nGenerate documentation bundle...\n"

.doc_impl_cpp: .vrt_doc_cpp
	$(A)cp -R $(V) $(TMP_DIR)/$(OUT_DOC_SUBDIR) $(OUTPUT_DIR)

.vrt_doc_cpp:
	@printf "\n\nGenerate Virtualization API documentation...\n"
	$(A)mkdir -p $(TMP_DIR)/$(TMP_VRT_DOC_SUBDIR)
	$(A)mkdir -p $(TMP_DIR)/$(OUT_DOC_SUBDIR)/$(VRT_SUBDIR)
	$(A)cp $(CPP_VIRTUALIZATION_API_HEADERS) $(TMP_DIR)/$(TMP_VRT_DOC_SUBDIR)
	$(A)cp $(DOC_DIR)/virtualization_overview.txt $(TMP_DIR)/$(TMP_VRT_DOC_SUBDIR)
	$(A)cd $(TMP_DIR)/$(TMP_VRT_DOC_SUBDIR); PLATFORM_API=$(PLATFORM_API) API_TYPE=$(VRT_API) RELEASE_VERSION=$(FULL_VERSION_NUMBER) DOC_DIR=./../../$(DOC_DIR) DOC_PART=$(VRT_API_DOC_PART) $(DOXYGEN) ./../../$(DOC_DIR)/documentation.conf
	$(A)cp $(CPP_LICENSE_FILE) $(TMP_DIR)/$(TMP_VRT_DOC_SUBDIR)/doc
	$(A)cp -R $(V) $(TMP_DIR)/$(TMP_VRT_DOC_SUBDIR)/doc/* $(TMP_DIR)/$(OUT_DOC_SUBDIR)/$(VRT_SUBDIR)

.post_doc_cpp:
	$(A)rm -rf $(TMP_DIR)
	@printf "Documentation generated !\n"

# check environment
.PHONY: check
check: .check_impl

