/*
 * Copyright (c) 2015, 2016, Oracle and/or its affiliates. All rights reserved.
 *
 * This software is dual-licensed to you under the MIT License (MIT) and
 * the Universal Permissive License (UPL). See the LICENSE file in the root
 * directory for license terms. You may choose either license, or both.
 */


/**
 * @brief Common private header
 */

#ifndef UTIL_KEY_VALUE_H
#define	UTIL_KEY_VALUE_H

#include "advanced/iotcs_message.h"

#ifdef	__cplusplus
extern "C" {
#endif

    /**
     * @brief Creates new iotcs_key_value structure
     * Arguments are copied.
     * @param key
     * @param value
     * @return 
     */
    iotcs_key_value* util_key_value_new(const char* key, const char* value);

    /**
     * @brief Compare two iotcs_key_values by their keys.
     * Functions return an integer
       less than, equal to, or greater than zero if field11 (or  the
       first  n  bytes  thereof)  is found, respectively, to be
       less than, to match, or be greater than field2.
     * @param field1
     * @param field2
     * @return 0 if equal, 
     */
    int util_compare_by_key(iotcs_key_value* field1, iotcs_key_value* field2);

    /**
     * @brief Compare two iotcs_key_values by their values.
     * Functions return an integer
       less than, equal to, or greater than zero if field11 (or  the
       first  n  bytes  thereof)  is found, respectively, to be
       less than, to match, or be greater than field2.
     * @param field1
     * @param field2
     * @return 
     */
    int util_compare_by_value(iotcs_key_value* field1, iotcs_key_value* field2);

    /**
     * @brief Destroy iotcs_key_value and release memory.
     * @param entry
     */
    void util_key_value_free(void* entry);

#ifdef	__cplusplus
}
#endif

#endif	/* UTIL_KEY_VALUE_H */

