/*
 * Copyright (c) 2015, 2016, Oracle and/or its affiliates. All rights reserved.
 *
 * This software is dual-licensed to you under the MIT License (MIT) and
 * the Universal Permissive License (UPL). See the LICENSE file in the root
 * directory for license terms. You may choose either license, or both.
 */


#ifndef HTTP_WRAPPER_H
#define HTTP_WRAPPER_H

/**
 * @brief Common private header
 */

#include <stddef.h>

#include "iotcs.h"
#include "protocol/protocol_request.h"

iotcs_result http_parse(protocol_response *response, char *buf, size_t len);
iotcs_result http_proceed_request(
        protocol_request request,
        protocol_response* response);

#ifdef IOTCS_LONG_POLLING
iotcs_result http_proceed_request_lp(
        protocol_request request,
        protocol_response* response,
        int32_t timeout);
#endif

void http_check_min_accept_bytes(protocol_response* response);

#endif /* HTTP_WRAPPER_H */