/*
 * Copyright (c) 2017, Oracle and/or its affiliates. All rights reserved.
 *
 * This software is dual-licensed to you under the MIT License (MIT) and
 * the Universal Permissive License (UPL). See the LICENSE file in the root
 * directory for license terms. You may choose either license, or both.
 */

/**
 * @file iotcs_port_persistence.h
 * @brief The file contains porting layer for policy.
 */

#ifndef IOTCS_PORT_PERSISTENCE_H
#define	IOTCS_PORT_PERSISTENCE_H

#include "iotcs.h"

#ifdef	__cplusplus
extern "C" {
#endif
	iotcs_result load_from_file(char *file_name, char **policy_buffer, iotcs_bool silent);
	void save_to_file(char *file_name, const char *buffer);
	void remove_file(char *file_name);
#ifdef	__cplusplus
}
#endif

#endif	/* IOTCS_PORT_PERSISTENCE_H */