/*
 * Copyright (c) 2015, 2016, Oracle and/or its affiliates. All rights reserved.
 *
 * This software is dual-licensed to you under the MIT License (MIT) and
 * the Universal Permissive License (UPL). See the LICENSE file in the root
 * directory for license terms. You may choose either license, or both.
 */

/**
 * @file iotcs_port_mutex.h
 * @brief The file contains porting layer for mutexes.
 */

#ifndef IOTCS_PORT_MUTEX_H
#define	IOTCS_PORT_MUTEX_H

#ifdef	__cplusplus
extern "C" {
#endif

#include "iotcs_config.h"

    /**
     * @typedef iotcs_port_mutex
     * @brief Mutex handle
     */
    typedef void* iotcs_port_mutex;

    /**
     * @brief Creates iotcs_port_mutex instance
     * @note Optional API. Called by the Library if IOTCS_MESSAGING_THREAD_SAFETY option is defined.
     * @return iotcs_port_mutex on success
     * @return NULL if failed
     */
    iotcs_port_mutex iotcs_port_mutex_create(void);

    /**
     * @brief Destroys iotcs_port_mutex instance
     * If a \a mutex is NULL, no operation is performed.
     * @note Optional API. Called by the Library if IOTCS_MESSAGING_THREAD_SAFETY option is defined.
     * @param mutex iotcs_port_mutex instance
     */
    void iotcs_port_mutex_destroy(iotcs_port_mutex mutex);

    /**
     * @brief Locks iotcs_port_mutex instance
     * Recursive lock support is not required. 
     * @note Optional API. Called by the Library if IOTCS_MESSAGING_THREAD_SAFETY option is defined.
     * @param mutex non NULL iotcs_port_mutex instance
     */
    void iotcs_port_mutex_lock(iotcs_port_mutex mutex);

    /**
     * @brief Unlocks iotcs_port_mutex instance
     * Recursive lock support is not required.
     * @note Optional API. Called by the Library if IOTCS_MESSAGING_THREAD_SAFETY option is defined.
     * @param mutex non NULL iotcs_port_mutex instance
     */
    void iotcs_port_mutex_unlock(iotcs_port_mutex mutex);

#ifdef	__cplusplus
}
#endif

#endif	/* IOTCS_PORT_MUTEX_H */

