# 
# Copyright (c) 2015, 2016, Oracle and/or its affiliates. All rights reserved.
#
# This software is dual-licensed to you under the MIT License (MIT) and the Universal Permissive License (UPL).  See the LICENSE file in the root directory for license terms.  You may choose
# either license, or both.
#

# Compile port source files into .o files
$(PORT_OBJ_DIR)/%.o: $(PORT_SRC_DIR)/%.c
	$(A)mkdir -p $(dir $@)
	$(A)$(CC) $(CPPFLAGS) $(CPP_OPTS) $(CFLAGS) $(C_OPTS) $(PORT_FLAGS) $(PORT_OPTS) $(OBJECT_FILE_NAME_OPT)$@ $<

# Compile port TAM source files into .o files
$(PORT_TAM_OBJ_DIR)/%.o: $(PORT_SRC_DIR)/%.c
	$(A)mkdir -p $(dir $@)
	$(A)$(CC) $(CPPFLAGS) $(CPP_OPTS) $(CFLAGS) $(C_OPTS) $(PORT_FLAGS) $(PORT_OPTS) $(TAM_FLAGS) $(TAM_OPTS) $(OBJECT_FILE_NAME_OPT)$@ $<

# create library
.library_impl: $(OUT_LIB_PATH) gen_libconf .print_lib_src $(OBJ_FILES) .print_port_src $(OBJ_PORT) .print_tam_src $(TAM_OBJ_FILES) .print_port_tam_src $(TAM_OBJ_PORT)
	@$(if $(filter true,$(DEFAULT_TAM)),                                    \
	    printf "Create %s IoTCS library with default TAM...\n" "$(PORT)"    \
	,                                                                       \
	    printf "Create %s IoTCS library without TAM...\n" "$(PORT)"         \
	)
	$(if $(filter true,$(DEFAULT_TAM)),                                        \
	    $(A)$(AR) rcs $(OUT_LIB_PATH)/$(OUT_LIB_NAME) $(OBJ_FILES) $(OBJ_PORT) $(TAM_OBJ_FILES) $(TAM_OBJ_PORT) \
	,                                                                          \
	    $(A)$(AR) rcs $(OUT_LIB_PATH)/$(OUT_LIB_NAME) $(OBJ_FILES) $(OBJ_PORT) \
	)

# create TAM library
.tam_library_impl: $(OUT_TAM_LIB_PATH) $(TAM_OBJ_DIR) .print_tam_src $(TAM_OBJ_FILES) .print_port_tam_src $(TAM_OBJ_PORT)
	@printf "Create %s IoTCS TAM library...\n" "$(PORT)"
	$(A)$(AR) rcs $(OUT_TAM_LIB_PATH)/$(OUT_TAM_LIB_NAME) $(TAM_OBJ_FILES) $(TAM_OBJ_PORT)

# create library (only shared part)
.library_shared_impl: $(OUT_LIB_PATH) gen_libconf .print_lib_src $(OBJ_FILES) .print_tam_src $(TAM_OBJ_FILES)
	@$(if $(filter true,$(DEFAULT_TAM)),                                    \
	    printf "Create %s IoTCS library only shared part with default TAM...\n" "$(PORT)" \
	,                                                                       \
	    printf "Create %s IoTCS library only shared part without TAM...\n" "$(PORT)" \
	)
	$(if $(filter true,$(DEFAULT_TAM)),                                        \
	    $(A)$(AR) rcs $(OUT_LIB_PATH)/$(OUT_LIB_NAME) $(OBJ_FILES) $(TAM_OBJ_FILES) \
	,                                                                          \
	    $(A)$(AR) rcs $(OUT_LIB_PATH)/$(OUT_LIB_NAME) $(OBJ_FILES) \
	)

# create library (only porting layer)
.library_porting_impl: $(OUT_LIB_PATH) gen_libconf .print_port_src $(OBJ_PORT) .print_port_tam_src $(TAM_OBJ_PORT)
	@$(if $(filter true,$(DEFAULT_TAM)),                                    \
	    printf "Create %s IoTCS library only porting layer with default TAM porting layer...\n" "$(PORT)" \
	,                                                                       \
	    printf "Create %s IoTCS library only porting layer without TAM porting layer...\n" "$(PORT)" \
	)
	$(if $(filter true,$(DEFAULT_TAM)),                                        \
	    $(A)$(AR) rcs $(OUT_LIB_PATH)/$(OUT_LIB_NAME) $(OBJ_PORT) $(TAM_OBJ_PORT) \
	,                                                                          \
	    $(A)$(AR) rcs $(OUT_LIB_PATH)/$(OUT_LIB_NAME) $(OBJ_PORT) \
	)

# build related targets
.pre_build: $(OUTPUT_DIR) check
	@printf "\nStart build library...\n"

.build_impl: print_conf print_libconf .library_impl bootstrapper

.post_build:
	@printf "Build library done !\n"

# clean related targets
.pre_clean:
	@printf "\nStart cleaning...\n"

.clean_impl:
	$(A)rm -rf $(V) $(OUTPUT_DIR)

.post_clean:
	@printf "Cleaning done !\n"

# configuration related targets
.print_libconf_impl:

.gen_libconf_impl:
	@printf "Generate %s specific library settings...\n" "$(PORT)"
	@printf "$(SCM)$(CMT) %s\n" "$(LINE_TRAP)" >> $(OUT_CONFIG_HEADER)
	@printf "$(CMT) Library %s specific port layer settings\n" "$(PORT)" >> $(OUT_CONFIG_HEADER)
	@printf "$(CMT) %s $(ECM)\n" "$(LINE_TRAP)" >> $(OUT_CONFIG_HEADER)

.check_impl:
