/*
 * Copyright (c) 2015, 2016, Oracle and/or its affiliates. All rights reserved.
 *
 * This software is dual-licensed to you under the MIT License (MIT) and
 * the Universal Permissive License (UPL). See the LICENSE file in the root
 * directory for license terms. You may choose either license, or both.
 */


#ifndef UTIL_THREAD_PRIVATE_H
#define UTIL_THREAD_PRIVATE_H

#include "iotcs_device.h"
#include "iotcs_port_mutex.h"

/**
 * @brief Common private header
 */

#ifdef    __cplusplus
extern "C" {
#endif

#ifdef IOTCS_MESSAGING_THREAD_SAFETY
    extern iotcs_port_mutex iotcs_LL_mutex;
#define UTIL_DECL_LL_LOCK() iotcs_port_mutex iotcs_LL_mutex;
#define UTIL_INIT_LL_LOCK() do { iotcs_LL_mutex = iotcs_port_mutex_create(); } while (0)
#define UTIL_FINIT_LL_LOCK() do { iotcs_port_mutex_destroy(iotcs_LL_mutex);\
                               iotcs_LL_mutex = NULL; } while(0)
#define UTIL_LOCK_LL() do { iotcs_port_mutex_lock(iotcs_LL_mutex); } while(0)
#define UTIL_UNLOCK_LL() do { iotcs_port_mutex_unlock(iotcs_LL_mutex); } while(0)
#else
#define UTIL_DECL_LL_LOCK()
#define UTIL_INIT_LL_LOCK() do {  } while(0)
#define UTIL_FINIT_LL_LOCK() do {  } while(0)
#define UTIL_LOCK_LL() do {  } while(0)
#define UTIL_UNLOCK_LL() do {  } while(0)
#endif

#ifdef IOTCS_LONG_POLLING
#ifdef IOTCS_MESSAGING_THREAD_SAFETY
    extern iotcs_port_mutex iotcs_LP_mutex;
#define UTIL_DECL_LP_LOCK() iotcs_port_mutex iotcs_LP_mutex;
#define UTIL_INIT_LP_LOCK() do { iotcs_LP_mutex = iotcs_port_mutex_create(); } while (0)
#define UTIL_FINIT_LP_LOCK() do { iotcs_port_mutex_destroy(iotcs_LP_mutex);\
                                   iotcs_LP_mutex = NULL; } while(0)
#define UTIL_LOCK_LP() do { iotcs_port_mutex_lock(iotcs_LP_mutex); } while(0)
#define UTIL_UNLOCK_LP() do { iotcs_port_mutex_unlock(iotcs_LP_mutex); } while(0)
#else
#define UTIL_DECL_LP_LOCK()
#define UTIL_INIT_LP_LOCK() do {  } while(0)
#define UTIL_FINIT_LP_LOCK() do {  } while(0)
#define UTIL_LOCK_LP() do {  } while(0)
#define UTIL_UNLOCK_LP() do {  } while(0)
#endif // IOTCS_MESSAGING_THREAD_SAFETY
#endif // IOTCS_LONG_POLLING

#ifdef IOTCS_STORAGE_SUPPORT
#ifdef IOTCS_MESSAGING_THREAD_SAFETY
    extern iotcs_port_mutex iotcs_SCS_mutex;
#define UTIL_DECL_SCS_LOCK() iotcs_port_mutex iotcs_SCS_mutex;
#define UTIL_INIT_SCS_LOCK() do { iotcs_SCS_mutex = iotcs_port_mutex_create(); } while (0)
#define UTIL_FINIT_SCS_LOCK() do { iotcs_port_mutex_destroy(\
        iotcs_SCS_mutex); iotcs_SCS_mutex = NULL; } while(0)
#define UTIL_LOCK_STORAGE() do { iotcs_port_mutex_lock(iotcs_SCS_mutex); } while(0)
#define UTIL_UNLOCK_STORAGE() do { iotcs_port_mutex_unlock(iotcs_SCS_mutex);\
        } while(0)
#else
#define UTIL_DECL_SCS_LOCK()
#define UTIL_INIT_SCS_LOCK() do {  } while(0)
#define UTIL_FINIT_SCS_LOCK() do {  } while(0)
#define UTIL_LOCK_STORAGE() do {  } while(0)
#define UTIL_UNLOCK_STORAGE() do {  } while(0)
#endif // IOTCS_MESSAGING_THREAD_SAFETY
#endif // IOTCS_STORAGE_SUPPORT

#if defined(IOTCS_MESSAGING_THREAD_SAFETY) && defined(IOTCS_VIRTUALIZATION_SUPPORT)
extern iotcs_port_mutex g_device_model_lock;
#define DM_LOCK() do {iotcs_port_mutex_lock(g_device_model_lock);} while(0)
#define DM_UNLOCK() do {iotcs_port_mutex_unlock(g_device_model_lock);} while(0)
#define UTIL_FINIT_DM_LOCK() do { iotcs_port_mutex_destroy(\
        g_device_model_lock); g_device_model_lock = NULL; } while(0)
#else
#define DM_LOCK() do {  } while(0)
#define DM_UNLOCK() do {  } while(0)
#define UTIL_FINIT_DM_LOCK() do { } while(0)
#endif // IOTCS_MESSAGING_THREAD_SAFETY

#ifdef    __cplusplus
}
#endif

#endif    /* UTIL_THREAD_PRIVATE_H */

